@extends('layouts.admin')

@section('title', 'Successful Deliveries')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-6 flex justify-between items-center">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Successful Deliveries</h1>
            <p class="text-xs sm:text-sm text-gray-600 mt-1">Review all successfully delivered parcels.</p>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Tracking #</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Rider</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Delivered At</th>
                        <th class="relative px-6 py-3">
                            <span class="sr-only">Actions</span>
                        </th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @foreach($successfulDeliveries as $delivery)
                        <tr>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs font-medium text-gray-900">{{ $delivery['tracking_number'] }}</td>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-500">{{ $delivery['rider'] }}</td>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-500">{{ $delivery['delivered_at'] }}</td>
                            <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                <a href="#" class="text-indigo-600 hover:text-indigo-900">View POD</a>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection


