@extends('layouts.admin')

@section('title', 'Admin Dashboard')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <!-- Header with Search -->
    <div class="mb-4 sm:mb-6 flex flex-col sm:flex-row items-start sm:items-center justify-between gap-3">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Admin Dashboard</h1>
            <p class="text-xs sm:text-sm text-gray-600 mt-1">Overview of system performance and activities</p>
        </div>
        <form method="GET" action="{{ route('admin.dashboard') }}" class="flex flex-col sm:flex-row items-stretch sm:items-center gap-2 w-full sm:w-auto">
            <div class="relative">
                <input name="q" value="{{ $q ?? '' }}" type="text" placeholder="Search tracking, recipient, seller..." class="w-full sm:w-64 pl-8 pr-3 py-1.5 sm:py-2 text-xs sm:text-sm border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                <svg class="w-3.5 h-3.5 sm:w-4 sm:h-4 text-gray-400 absolute left-2.5 top-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                </svg>
            </div>
            <select name="period" class="text-xs sm:text-sm border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 focus:outline-none focus:ring-2 focus:ring-blue-500">
                <option value="">All time</option>
                <option value="7" @selected(($period ?? '')==='7')>Last 7 days</option>
                <option value="30" @selected(($period ?? '')==='30')>Last 30 days</option>
                <option value="90" @selected(($period ?? '')==='90')>Last 90 days</option>
            </select>
            <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Apply</button>
        </form>
    </div>

    <!-- Stats Grid -->
    <div class="grid grid-cols-2 sm:grid-cols-3 lg:grid-cols-5 gap-3 sm:gap-4 mb-4 sm:mb-6">
        <!-- Total Bookings -->
        <div class="bg-white rounded-lg shadow-md p-3 sm:p-4">
            <div class="flex items-center justify-between mb-1.5">
                <p class="text-[10px] sm:text-[11px] font-medium text-gray-600">Total Bookings</p>
                <svg class="w-3 h-3 sm:w-3.5 sm:h-3.5 text-blue-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                </svg>
            </div>
            <p class="text-lg sm:text-xl lg:text-2xl font-bold text-gray-900">{{ $totalParcels }}</p>
            <p class="text-[9px] sm:text-[10px] text-gray-500 mt-0.5">Parcel bookings</p>
        </div>

        <!-- Total Delivered -->
        <div class="bg-white rounded-lg shadow-md p-3 sm:p-4">
            <div class="flex items-center justify-between mb-1.5">
                <p class="text-[10px] sm:text-[11px] font-medium text-gray-600">Total Delivered</p>
                <svg class="w-3 h-3 sm:w-3.5 sm:h-3.5 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                </svg>
            </div>
            <p class="text-lg sm:text-xl lg:text-2xl font-bold text-gray-900">{{ $deliveredParcels }}</p>
            <p class="text-[9px] sm:text-[10px] text-gray-500 mt-0.5">Successful deliveries</p>
        </div>

        <!-- Total Sellers -->
        <div class="bg-white rounded-lg shadow-md p-3 sm:p-4">
            <div class="flex items-center justify-between mb-1.5">
                <p class="text-[10px] sm:text-[11px] font-medium text-gray-600">Total Sellers</p>
                <svg class="w-3 h-3 sm:w-3.5 sm:h-3.5 text-purple-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"/>
                </svg>
            </div>
            <p class="text-lg sm:text-xl lg:text-2xl font-bold text-gray-900">{{ $totalSellers }}</p>
            <p class="text-[9px] sm:text-[10px] text-gray-500 mt-0.5">Registered sellers</p>
        </div>

        <!-- Total Riders -->
        <div class="bg-white rounded-lg shadow-md p-3 sm:p-4">
            <div class="flex items-center justify-between mb-1.5">
                <p class="text-[10px] sm:text-[11px] font-medium text-gray-600">Total Riders</p>
                <svg class="w-3 h-3 sm:w-3.5 sm:h-3.5 text-indigo-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                </svg>
            </div>
            <p class="text-lg sm:text-xl lg:text-2xl font-bold text-gray-900">{{ $totalRiders }}</p>
            <p class="text-[9px] sm:text-[10px] text-gray-500 mt-0.5">Active riders</p>
        </div>

        <!-- Total Branches -->
        <div class="bg-white rounded-lg shadow-md p-3 sm:p-4">
            <div class="flex items-center justify-between mb-1.5">
                <p class="text-[10px] sm:text-[11px] font-medium text-gray-600">Total Branches</p>
                <svg class="w-3 h-3 sm:w-3.5 sm:h-3.5 text-orange-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"/>
                </svg>
            </div>
            <p class="text-lg sm:text-xl lg:text-2xl font-bold text-gray-900">{{ $totalBranches }}</p>
            <p class="text-[9px] sm:text-[10px] text-gray-500 mt-0.5">Total branches</p>
        </div>
    </div>

    <!-- Financial Cards Row -->
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-3 sm:gap-4 mb-4 sm:mb-6">
        <!-- Pending COD -->
        <div class="bg-white rounded-lg shadow-md p-3 sm:p-4">
            <div class="flex items-center justify-between mb-1.5">
                <p class="text-[10px] sm:text-[11px] font-medium text-gray-600">Pending COD</p>
                <svg class="w-3 h-3 sm:w-3.5 sm:h-3.5 text-yellow-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                </svg>
            </div>
            <p class="text-base sm:text-lg lg:text-xl font-bold text-gray-900">Rs. {{ number_format($pendingCOD, 2) }}</p>
            <p class="text-[9px] sm:text-[10px] text-gray-500 mt-0.5">Awaiting collection</p>
        </div>

        <!-- Reconciled COD -->
        <div class="bg-white rounded-lg shadow-md p-3 sm:p-4">
            <div class="flex items-center justify-between mb-1.5">
                <p class="text-[10px] sm:text-[11px] font-medium text-gray-600">Reconciled COD</p>
                <svg class="w-3 h-3 sm:w-3.5 sm:h-3.5 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                </svg>
            </div>
            <p class="text-base sm:text-lg lg:text-xl font-bold text-gray-900">Rs. {{ number_format($reconciledCOD, 2) }}</p>
            <p class="text-[9px] sm:text-[10px] text-gray-500 mt-0.5">Verified & reconciled</p>
        </div>

        <!-- Total Expenses -->
        <div class="bg-white rounded-lg shadow-md p-3 sm:p-4">
            <div class="flex items-center justify-between mb-1.5">
                <p class="text-[10px] sm:text-[11px] font-medium text-gray-600">Total Expenses</p>
                <svg class="w-3 h-3 sm:w-3.5 sm:h-3.5 text-red-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 14l6-6m-5.5.5h.01m4.99 5h.01M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16l3.5-2 3.5 2 3.5-2 3.5 2z"/>
                </svg>
            </div>
            <p class="text-base sm:text-lg lg:text-xl font-bold text-gray-900">Rs. {{ number_format($totalExpenses, 2) }}</p>
            <p class="text-[9px] sm:text-[10px] text-gray-500 mt-0.5">This month's expenses</p>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="bg-white rounded-lg shadow-md p-4 sm:p-6 mb-4 sm:mb-6">
        <h2 class="text-base sm:text-lg font-bold text-gray-900 mb-3 sm:mb-4">Quick Actions</h2>
        <div class="flex flex-wrap gap-2 sm:gap-3">
            <a href="{{ route('admin.parcels.index') }}" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">
                📦 View All Parcels
            </a>
            <a href="{{ route('admin.merchants.index') }}" class="bg-purple-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-purple-700 transition">
                🏢 Manage Merchants
            </a>
            <a href="{{ route('admin.complaints.index') }}" class="bg-orange-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-orange-700 transition">
                ⚠️ View Complaints
            </a>
        </div>
    </div>

    <!-- Recent Parcels -->
    <div class="bg-white rounded-lg shadow-md overflow-hidden mb-4 sm:mb-6">
        <div class="px-4 sm:px-6 py-3 sm:py-4 border-b border-gray-200">
            <div class="flex justify-between items-center">
                <h2 class="text-base sm:text-lg font-bold text-gray-900">Recent Parcels</h2>
                <a href="{{ route('admin.parcels.index') }}" class="text-xs sm:text-sm text-blue-600 hover:text-blue-800">View All →</a>
            </div>
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Tracking ID</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Seller</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Recipient</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">COD Amount</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Status</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($recentParcels as $parcel)
                    <tr>
                        <td class="px-4 py-2.5 whitespace-nowrap text-xs font-medium text-blue-600">
                            <a href="{{ route('admin.parcels.show', $parcel) }}">{{ $parcel->tracking_id }}</a>
                        </td>
                        <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-900">{{ $parcel->seller->company_name }}</td>
                        <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-900">{{ $parcel->recipient_name }}</td>
                        <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-900">PKR {{ number_format($parcel->cod_amount, 2) }}</td>
                        <td class="px-4 py-2.5 whitespace-nowrap">
                            <span class="px-2 inline-flex text-[10px] leading-4 font-semibold rounded-full 
                                @if($parcel->status === 'Delivered') bg-green-100 text-green-800
                                @elseif($parcel->status === 'Pending') bg-yellow-100 text-yellow-800
                                @elseif(in_array($parcel->status, ['In Transit', 'Picked Up'])) bg-blue-100 text-blue-800
                                @else bg-red-100 text-red-800
                                @endif">
                                {{ $parcel->status }}
                            </span>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="5" class="px-4 py-3 text-center text-xs text-gray-500">No parcels found</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <!-- Active Complaints -->
    @if($activeComplaints->count() > 0)
    <div class="bg-white rounded border border-gray-200 overflow-hidden">
        <div class="px-4 py-3 border-b border-gray-200">
            <h2 class="text-base font-bold text-gray-900">Active Complaints</h2>
        </div>
        <div class="divide-y divide-gray-200">
            @foreach($activeComplaints as $complaint)
            <div class="px-4 py-3">
                <div class="flex items-center justify-between">
                    <div>
                        <h3 class="text-xs font-semibold text-gray-900">{{ $complaint->subject }}</h3>
                        <p class="text-[11px] text-gray-600">Parcel: {{ $complaint->parcel->tracking_id }} | Seller: {{ $complaint->seller->company_name }}</p>
                    </div>
                    <span class="px-2 py-1 text-[10px] font-semibold rounded-full 
                        @if($complaint->status === 'Open') bg-red-100 text-red-800
                        @else bg-yellow-100 text-yellow-800
                        @endif">
                        {{ $complaint->status }}
                    </span>
                </div>
            </div>
            @endforeach
        </div>
    </div>
    @endif
</div>
@endsection
