@extends('layouts.admin')

@section('title', 'Edit Div')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-4 sm:mb-6 flex items-start sm:items-center justify-between">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Edit Div</h1>
            <p class="text-xs sm:text-sm text-gray-600 mt-1">Update the Div record</p>
        </div>
        <a href="{{ route('admin.divs.index') }}" class="text-xs sm:text-sm text-gray-700 hover:text-gray-900">Back to list</a>
    </div>

    @if($errors->any())
        <div class="mb-4 p-3 bg-red-50 border border-red-200 text-red-700 rounded text-xs sm:text-sm">
            <ul class="list-disc pl-4">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <div class="bg-white rounded-lg shadow-md p-4 sm:p-6">
        <form method="POST" action="{{ route('admin.divs.update', $div) }}" class="grid grid-cols-1 sm:grid-cols-2 gap-3 sm:gap-4">
            @csrf
            @method('PUT')

            <div>
                <label class="block text-xs sm:text-sm font-medium text-gray-700">Name</label>
                <input type="text" name="name" value="{{ old('name', $div->name) }}" class="mt-1 w-full border border-gray-300 rounded px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500" required>
            </div>

            <div>
                <label class="block text-xs sm:text-sm font-medium text-gray-700">Code</label>
                <input type="text" name="code" value="{{ old('code', $div->code) }}" class="mt-1 w-full border border-gray-300 rounded px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500" required>
            </div>

            <div>
                <label class="block text-xs sm:text-sm font-medium text-gray-700">Category</label>
                <input type="text" name="category" value="{{ old('category', $div->category) }}" class="mt-1 w-full border border-gray-300 rounded px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>

            <div>
                <label class="block text-xs sm:text-sm font-medium text-gray-700">Owner</label>
                <input type="text" name="owner" value="{{ old('owner', $div->owner) }}" class="mt-1 w-full border border-gray-300 rounded px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>

            <div>
                <label class="block text-xs sm:text-sm font-medium text-gray-700">Status</label>
                <select name="status" class="mt-1 w-full border border-gray-300 rounded px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                    <option value="active" {{ old('status', $div->status)==='active' ? 'selected' : '' }}>Active</option>
                    <option value="inactive" {{ old('status', $div->status)==='inactive' ? 'selected' : '' }}>Inactive</option>
                    <option value="archived" {{ old('status', $div->status)==='archived' ? 'selected' : '' }}>Archived</option>
                </select>
            </div>

            <div>
                <label class="block text-xs sm:text-sm font-medium text-gray-700">Start Date</label>
                <input type="date" name="start_date" value="{{ old('start_date', optional($div->start_date)->format('Y-m-d')) }}" class="mt-1 w-full border border-gray-300 rounded px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>

            <div>
                <label class="block text-xs sm:text-sm font-medium text-gray-700">End Date</label>
                <input type="date" name="end_date" value="{{ old('end_date', optional($div->end_date)->format('Y-m-d')) }}" class="mt-1 w-full border border-gray-300 rounded px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>

            <div class="sm:col-span-2">
                <label class="block text-xs sm:text-sm font-medium text-gray-700">Notes</label>
                <textarea name="notes" rows="4" class="mt-1 w-full border border-gray-300 rounded px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500">{{ old('notes', $div->notes) }}</textarea>
            </div>

            <div class="sm:col-span-2 flex items-center gap-2 mt-2">
                <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Update</button>
                <a href="{{ route('admin.divs.index') }}" class="text-xs sm:text-sm text-gray-700 hover:text-gray-900">Cancel</a>
            </div>
        </form>
    </div>
</div>
@endsection