@extends('layouts.admin')

@section('title', 'Div Management')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-4 sm:mb-6 flex flex-col sm:flex-row items-start sm:items-center justify-between gap-3">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Div Management</h1>
            <p class="text-xs sm:text-sm text-gray-600 mt-1">Create, view, edit, and delete Div records</p>
        </div>
        <a href="{{ route('admin.divs.create') }}" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Add Div</a>
    </div>

    @if(session('success'))
        <div class="mb-4 p-3 bg-green-50 border border-green-200 text-green-700 rounded text-xs sm:text-sm">{{ session('success') }}</div>
    @endif
    @if($errors->any())
        <div class="mb-4 p-3 bg-red-50 border border-red-200 text-red-700 rounded text-xs sm:text-sm">
            <ul class="list-disc pl-4">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form method="GET" class="mb-4 sm:mb-6 grid grid-cols-1 sm:grid-cols-3 gap-2 sm:gap-3">
        <input type="text" name="search" value="{{ $search }}" placeholder="Search by name, code, owner" class="w-full border border-gray-300 rounded px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500">
        <select name="status" class="w-full border border-gray-300 rounded px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500">
            <option value="">All Status</option>
            <option value="active" {{ $status==='active' ? 'selected' : '' }}>Active</option>
            <option value="inactive" {{ $status==='inactive' ? 'selected' : '' }}>Inactive</option>
            <option value="archived" {{ $status==='archived' ? 'selected' : '' }}>Archived</option>
        </select>
        <button class="bg-gray-800 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-gray-900 transition">Filter</button>
    </form>

    <div class="bg-white rounded-lg shadow-md overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Name</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Code</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Category</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Owner</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Status</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Period</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($divs as $div)
                    <tr class="hover:bg-gray-50">
                        <td class="px-4 py-2.5 whitespace-nowrap text-xs font-medium text-gray-900">{{ $div->name }}</td>
                        <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-900">{{ $div->code }}</td>
                        <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-900">{{ $div->category }}</td>
                        <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-900">{{ $div->owner }}</td>
                        <td class="px-4 py-2.5 whitespace-nowrap">
                            <span class="px-2 inline-flex text-[10px] leading-4 font-semibold rounded-full
                                @if($div->status==='active') bg-green-100 text-green-800
                                @elseif($div->status==='inactive') bg-yellow-100 text-yellow-800
                                @else bg-gray-100 text-gray-800 @endif">
                                {{ ucfirst($div->status) }}
                            </span>
                        </td>
                        <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-900">{{ optional($div->start_date)->format('Y-m-d') }} — {{ optional($div->end_date)->format('Y-m-d') }}</td>
                        <td class="px-4 py-2.5 whitespace-nowrap text-xs font-medium space-x-2">
                            <a href="{{ route('admin.divs.show', $div) }}" class="text-blue-600 hover:text-blue-800">View</a>
                            <a href="{{ route('admin.divs.edit', $div) }}" class="text-indigo-600 hover:text-indigo-800">Edit</a>
                            <form action="{{ route('admin.divs.destroy', $div) }}" method="POST" class="inline" onsubmit="return confirm('Delete this record?');">
                                @csrf
                                @method('DELETE')
                                <button class="text-red-600 hover:text-red-800">Delete</button>
                            </form>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="7" class="px-4 py-3 text-center text-xs text-gray-500">No records found.</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <div class="mt-4">{{ $divs->links() }}</div>
</div>
@endsection
