@extends('layouts.admin')

@section('title', 'Div Details')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-4 sm:mb-6 flex items-start sm:items-center justify-between">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Div Details</h1>
            <p class="text-xs sm:text-sm text-gray-600 mt-1">View the Div record</p>
        </div>
        <div class="space-x-2">
            <a href="{{ route('admin.divs.index') }}" class="text-xs sm:text-sm text-gray-700 hover:text-gray-900">Back to list</a>
            <a href="{{ route('admin.divs.edit', $div) }}" class="text-xs sm:text-sm text-indigo-600 hover:text-indigo-800">Edit</a>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow-md p-4 sm:p-6">
        <dl class="grid grid-cols-1 sm:grid-cols-2 gap-3 sm:gap-4">
            <div>
                <dt class="text-xs sm:text-sm font-medium text-gray-500">Name</dt>
                <dd class="mt-1 text-xs sm:text-sm text-gray-900">{{ $div->name }}</dd>
            </div>
            <div>
                <dt class="text-xs sm:text-sm font-medium text-gray-500">Code</dt>
                <dd class="mt-1 text-xs sm:text-sm text-gray-900">{{ $div->code }}</dd>
            </div>
            <div>
                <dt class="text-xs sm:text-sm font-medium text-gray-500">Category</dt>
                <dd class="mt-1 text-xs sm:text-sm text-gray-900">{{ $div->category }}</dd>
            </div>
            <div>
                <dt class="text-xs sm:text-sm font-medium text-gray-500">Owner</dt>
                <dd class="mt-1 text-xs sm:text-sm text-gray-900">{{ $div->owner }}</dd>
            </div>
            <div>
                <dt class="text-xs sm:text-sm font-medium text-gray-500">Status</dt>
                <dd class="mt-1 text-xs sm:text-sm">
                    <span class="px-2 inline-flex text-[10px] leading-4 font-semibold rounded-full
                        @if($div->status==='active') bg-green-100 text-green-800
                        @elseif($div->status==='inactive') bg-yellow-100 text-yellow-800
                        @else bg-gray-100 text-gray-800 @endif">
                        {{ ucfirst($div->status) }}
                    </span>
                </dd>
            </div>
            <div class="sm:col-span-2">
                <dt class="text-xs sm:text-sm font-medium text-gray-500">Period</dt>
                <dd class="mt-1 text-xs sm:text-sm text-gray-900">{{ optional($div->start_date)->format('Y-m-d') }} — {{ optional($div->end_date)->format('Y-m-d') }}</dd>
            </div>
            <div class="sm:col-span-2">
                <dt class="text-xs sm:text-sm font-medium text-gray-500">Notes</dt>
                <dd class="mt-1 text-xs sm:text-sm text-gray-900">{{ $div->notes }}</dd>
            </div>
        </dl>
    </div>
</div>
@endsection