@extends('layouts.admin')

@section('title', 'Balance Sheet')

@section('content')
<div class="p-6 lg:p-8">
    <!-- Page Header -->
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-800">Balance Sheet</h1>
            <p class="text-sm text-gray-600">As of {{ date('F jS, Y') }}</p>
        </div>
        <button onclick="window.print();" class="bg-white border border-gray-300 text-gray-700 px-3 py-2 rounded-md hover:bg-gray-50">Print</button>
    </div>

    <!-- Balance Sheet Content -->
    <div class="bg-white rounded-lg shadow-md p-6">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
            <!-- Left Side: Assets -->
            <div>
                <h2 class="text-lg font-semibold border-b pb-2 mb-3">Assets</h2>
                @foreach($assets as $category => $accounts)
                    <h3 class="text-md font-medium text-gray-700 mt-4">{{ ucwords(str_replace('_', ' ', $category)) }}</h3>
                    <table class="min-w-full mt-2">
                        <tbody>
                            @foreach($accounts as $account)
                                <tr class="border-b">
                                    <td class="py-2 pr-2">{{ $account->account_name }}</td>
                                    <td class="py-2 pl-2 text-right">{{ number_format($account->balance, 2) }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                @endforeach
                <div class="border-t-2 mt-4 pt-2 font-bold flex justify-between">
                    <span>Total Assets</span>
                    <span>Rs. {{ number_format($totalAssets, 2) }}</span>
                </div>
            </div>

            <!-- Right Side: Liabilities & Equity -->
            <div>
                <h2 class="text-lg font-semibold border-b pb-2 mb-3">Liabilities & Equity</h2>
                
                <h3 class="text-md font-medium text-gray-700 mt-4">Liabilities</h3>
                @foreach($liabilities as $category => $accounts)
                    <h4 class="text-sm font-medium text-gray-600 mt-3 pl-2">{{ ucwords(str_replace('_', ' ', $category)) }}</h4>
                    <table class="min-w-full mt-2">
                        <tbody>
                            @foreach($accounts as $account)
                                <tr class="border-b">
                                    <td class="py-2 pr-2">{{ $account->account_name }}</td>
                                    <td class="py-2 pl-2 text-right">{{ number_format($account->balance, 2) }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                @endforeach
                <div class="border-t mt-3 pt-2 font-semibold flex justify-between">
                    <span>Total Liabilities</span>
                    <span>Rs. {{ number_format($totalLiabilities, 2) }}</span>
                </div>

                <h3 class="text-md font-medium text-gray-700 mt-6">Equity</h3>
                @foreach($equity as $category => $accounts)
                    <table class="min-w-full mt-2">
                        <tbody>
                            @foreach($accounts as $account)
                                <tr class="border-b">
                                    <td class="py-2 pr-2">{{ $account->account_name }}</td>
                                    <td class="py-2 pl-2 text-right">{{ number_format($account->balance, 2) }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                @endforeach
                <div class="border-t mt-3 pt-2 font-semibold flex justify-between">
                    <span>Total Equity</span>
                    <span>Rs. {{ number_format($totalEquity, 2) }}</span>
                </div>

                <div class="border-t-2 mt-4 pt-2 font-bold flex justify-between">
                    <span>Total Liabilities & Equity</span>
                    <span>Rs. {{ number_format($totalLiabilities + $totalEquity, 2) }}</span>
                </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

