@extends('layouts.admin')

@section('title', 'Edit Account')

@section('content')
<div class="p-6 lg:p-8">
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-800">Edit Account</h1>
            <p class="text-sm text-gray-600">Update account details.</p>
        </div>
        <a href="{{ url('finance/accounting.chart-of-accounts') }}" class="bg-white text-gray-700 px-4 py-2 rounded-lg border shadow-sm hover:bg-gray-50">Back</a>
    </div>

    <div class="bg-white rounded-lg shadow-md p-6">
        <form action="{{ url('finance/accounting.chart-of-accounts.update', $account) }}" method="POST">
            @csrf
            @method('PUT')
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Account Name</label>
                    <input type="text" name="account_name" value="{{ $account->account_name }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                </div>
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Account Code</label>
                    <input type="text" name="account_code" value="{{ $account->account_code }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                </div>
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Account Type</label>
                    <select name="account_type" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                        <option value="asset" {{ $account->account_type == 'asset' ? 'selected' : '' }}>Asset</option>
                        <option value="liability" {{ $account->account_type == 'liability' ? 'selected' : '' }}>Liability</option>
                        <option value="equity" {{ $account->account_type == 'equity' ? 'selected' : '' }}>Equity</option>
                        <option value="revenue" {{ $account->account_type == 'revenue' ? 'selected' : '' }}>Revenue</option>
                        <option value="expense" {{ $account->account_type == 'expense' ? 'selected' : '' }}>Expense</option>
                    </select>
                </div>
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Account Category</label>
                    <select name="account_category" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                        <option value="current_asset" {{ $account->account_category == 'current_asset' ? 'selected' : '' }}>Current Asset</option>
                        <option value="fixed_asset" {{ $account->account_category == 'fixed_asset' ? 'selected' : '' }}>Fixed Asset</option>
                        <option value="current_liability" {{ $account->account_category == 'current_liability' ? 'selected' : '' }}>Current Liability</option>
                        <option value="long_term_liability" {{ $account->account_category == 'long_term_liability' ? 'selected' : '' }}>Long-Term Liability</option>
                        <option value="equity" {{ $account->account_category == 'equity' ? 'selected' : '' }}>Equity</option>
                        <option value="revenue" {{ $account->account_category == 'revenue' ? 'selected' : '' }}>Revenue</option>
                        <option value="cost_of_goods_sold" {{ $account->account_category == 'cost_of_goods_sold' ? 'selected' : '' }}>Cost of Goods Sold</option>
                        <option value="operating_expense" {{ $account->account_category == 'operating_expense' ? 'selected' : '' }}>Operating Expense</option>
                        <option value="other" {{ $account->account_category == 'other' ? 'selected' : '' }}>Other</option>
                    </select>
                </div>
                <div class="md:col-span-2">
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Description</label>
                    <textarea name="description" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">{{ $account->description }}</textarea>
                </div>
            </div>
            <div class="flex justify-end mt-6">
                <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Update Account</button>
            </div>
        </form>
    </div>
</div>
@endsection


