@extends('layouts.admin')

@section('title', 'General Ledger')

@section('content')
<div class="p-6 lg:p-8">
    <!-- Page Header -->
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-800">General Ledger</h1>
            <p class="text-sm text-gray-600">View detailed transactions for any account.</p>
        </div>
    </div>

    <!-- Filter Form -->
    <div class="bg-white rounded-lg shadow-md p-4 mb-6">
        <form method="GET" action="{{ route('finance.accounting.ledger') }}" class="grid grid-cols-1 md:grid-cols-4 gap-4 items-end">
            <div class="md:col-span-2">
                <label for="account_id" class="block text-xs sm:text-sm font-medium text-gray-700">Account</label>
                <select name="account_id" id="account_id" class="mt-1 form-select" required>
                    <option value="">Select an account</option>
                    @foreach($accounts as $account)
                        <option value="{{ $account->id }}" {{ optional($selectedAccount)->id == $account->id ? 'selected' : '' }}>
                            {{ $account->account_code }} - {{ $account->account_name }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div>
                <label for="start_date" class="block text-xs sm:text-sm font-medium text-gray-700">Start Date</label>
                <input type="date" name="start_date" id="start_date" value="{{ $startDate }}" class="mt-1 form-input">
            </div>
            <div>
                <label for="end_date" class="block text-xs sm:text-sm font-medium text-gray-700">End Date</label>
                <input type="date" name="end_date" id="end_date" value="{{ $endDate }}" class="mt-1 form-input">
            </div>
            <div>
                <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">View Ledger</button>
            </div>
        </form>
    </div>

    @if($selectedAccount)
    <!-- Ledger Table -->
    <div class="bg-white rounded-lg shadow-md">
        <div class="p-4 border-b flex justify-between items-center">
            <h3 class="text-lg font-semibold">Ledger for: {{ $selectedAccount->account_name }}</h3>
            <div class="text-right">
                <div class="text-sm text-gray-500">Current Balance</div>
                <div class="text-xl font-bold text-gray-800">Rs. {{ number_format($selectedAccount->balance, 2) }}</div>
            </div>
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Date</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Description</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Reference</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Debit</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Credit</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Running Balance</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @php $runningBalance = 0; @endphp
                    @forelse($transactions as $transaction)
                        @php
                            if ($transaction->type == 'debit') $runningBalance += $transaction->amount; else $runningBalance -= $transaction->amount;
                        @endphp
                        <tr>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-500">{{ $transaction->journalEntry->entry_date->format('M d, Y') }}</td>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-900">{{ $transaction->journalEntry->description }}</td>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-500">{{ $transaction->journalEntry->reference }}</td>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs text-right text-green-600">{{ $transaction->type == 'debit' ? 'Rs. ' . number_format($transaction->amount, 2) : '-' }}</td>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs text-right text-red-600">{{ $transaction->type == 'credit' ? 'Rs. ' . number_format($transaction->amount, 2) : '-' }}</td>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs text-right font-medium">Rs. {{ number_format($runningBalance, 2) }}</td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="text-center py-10 text-gray-500">No transactions found for this account.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
    @else
    <div class="bg-white rounded-lg shadow-md text-center py-10">
        <p class="text-gray-500">Please select an account to view its ledger.</p>
    </div>
    @endif
</div>
@endsection



