@extends('layouts.admin')

@section('title', 'Profit & Loss Statement')

@section('content')
<div class="p-6 lg:p-8">
    <!-- Page Header -->
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-800">Profit & Loss Statement</h1>
            <p class="text-sm text-gray-600">For the period from {{ \Carbon\Carbon::parse($startDate)->format('M d, Y') }} to {{ \Carbon\Carbon::parse($endDate)->format('M d, Y') }}</p>
        </div>
        <button onclick="window.print();" class="bg-white border border-gray-300 text-gray-700 px-3 py-2 rounded-md hover:bg-gray-50">Print</button>
    </div>

    <!-- Filter Form -->
    <div class="bg-white rounded-lg shadow-md p-4 mb-6">
        <form method="GET" action="{{ route('finance.accounting.profit-loss') }}" class="grid grid-cols-1 md:grid-cols-3 gap-4 items-end">
            <div>
                <label for="start_date" class="block text-xs sm:text-sm font-medium text-gray-700">Start Date</label>
                <input type="date" name="start_date" id="start_date" value="{{ $startDate }}" class="mt-1 form-input">
            </div>
            <div>
                <label for="end_date" class="block text-xs sm:text-sm font-medium text-gray-700">End Date</label>
                <input type="date" name="end_date" id="end_date" value="{{ $endDate }}" class="mt-1 form-input">
            </div>
            <div>
                <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Generate Report</button>
            </div>
        </form>
    </div>

    <!-- P&L Table -->
    <div class="bg-white rounded-lg shadow-md p-6">
        <!-- Revenue Section -->
        <div>
            <h2 class="text-lg font-semibold border-b pb-2 mb-3">Revenue</h2>
            <table class="min-w-full mt-2">
                <tbody>
                    @forelse($revenues as $revenue)
                        <tr class="border-b">
                            <td class="py-2 pr-2">{{ $revenue->account_name }}</td>
                            <td class="py-2 pl-2 text-right">{{ number_format($revenue->journalLines->where('type','credit')->sum('amount'), 2) }}</td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="2" class="py-3 text-center text-gray-500">No revenue accounts found for selected period.</td>
                        </tr>
                    @endforelse
                </tbody>
                <tfoot class="font-semibold">
                    <tr class="border-t-2">
                        <td class="py-2 pr-2">Total Revenue</td>
                        <td class="py-2 pl-2 text-right">{{ number_format($totalRevenue, 2) }}</td>
                    </tr>
                </tfoot>
            </table>
        </div>

        <!-- Expenses Section -->
        <div class="mt-8">
            <h2 class="text-lg font-semibold border-b pb-2 mb-3">Expenses</h2>
            <table class="min-w-full mt-2">
                <tbody>
                    @forelse($expenses as $expense)
                        <tr class="border-b">
                            <td class="py-2 pr-2">{{ $expense->account_name }}</td>
                            <td class="py-2 pl-2 text-right">{{ number_format($expense->journalLines->where('type','debit')->sum('amount'), 2) }}</td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="2" class="py-3 text-center text-gray-500">No expense accounts found for selected period.</td>
                        </tr>
                    @endforelse
                </tbody>
                <tfoot class="font-semibold">
                    <tr class="border-t-2">
                        <td class="py-2 pr-2">Total Expenses</td>
                        <td class="py-2 pl-2 text-right">{{ number_format($totalExpenses, 2) }}</td>
                    </tr>
                </tfoot>
            </table>
        </div>

        <!-- Net Profit/Loss Section -->
        <div class="mt-8 pt-4 border-t-4">
            <div class="flex justify-between font-bold text-xl">
                <span>Net {{ $netProfit >= 0 ? 'Profit' : 'Loss' }}</span>
                <span class="{{ $netProfit >= 0 ? 'text-green-600' : 'text-red-600' }}">
                    Rs. {{ number_format(abs($netProfit), 2) }}
                </span>
            </div>
        </div>
    </div>
</div>

@endsection


