@extends('layouts.admin')

@section('title', 'Trial Balance')

@section('content')
<div class="p-6 lg:p-8">
    <!-- Page Header -->
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-800">Trial Balance</h1>
            <p class="text-sm text-gray-600">As of {{ date('F jS, Y') }}</p>
        </div>
        <button onclick="window.print();" class="bg-white border border-gray-300 text-gray-700 px-3 py-2 rounded-md hover:bg-gray-50">Print</button>
    </div>

    <!-- Trial Balance Table -->
    <div class="bg-white rounded-lg shadow-md">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Code</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Account</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Debit</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Credit</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($balances as $balance)
                        <tr>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-500">{{ $balance['account_code'] }}</td>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs font-medium text-gray-900">{{ $balance['account_name'] }}</td>
                            <td class="px-6 py-4 text-right text-sm">{{ $balance['debit'] > 0 ? number_format($balance['debit'], 2) : '-' }}</td>
                            <td class="px-6 py-4 text-right text-sm">{{ $balance['credit'] > 0 ? number_format($balance['credit'], 2) : '-' }}</td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="4" class="text-center py-10 text-gray-500">No accounts with balances found.</td>
                        </tr>
                    @endforelse
                </tbody>
                <tfoot class="bg-gray-100">
                    <tr class="font-bold text-gray-900">
                        <td colspan="2" class="px-6 py-3 text-right">Totals</td>
                        <td class="px-6 py-3 text-right">Rs. {{ number_format($totalDebit, 2) }}</td>
                        <td class="px-6 py-3 text-right">Rs. {{ number_format($totalCredit, 2) }}</td>
                    </tr>
                    @if(round($totalDebit, 2) !== round($totalCredit, 2))
                        <tr>
                            <td colspan="4" class="px-6 py-2 text-center text-red-600 bg-red-50 text-sm">
                                Warning: Totals do not match!
                            </td>
                        </tr>
                    @endif
                </tfoot>
            </table>
        </div>
    </div>
</div>
@endsection



