@extends('layouts.admin')

@section('title', 'Access Controls')

@section('content')
<div class="p-6 lg:p-8" x-data="{ showModal: false }" @open-modal.window="showModal = true">
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-800">Access Controls</h1>
            <p class="text-sm text-gray-600">Manage system access permissions and reviews.</p>
        </div>
        <button @click="showModal = true" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">New Control</button>
    </div>

    <!-- Access Controls Table -->
    <div class="bg-white rounded-lg shadow-md">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Title</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Owner</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Review Date</th>
                        <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase">Status</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($accessControls as $control)
                        <tr>
                            <td class="px-6 py-4">{{ $control->title }}</td>
                            <td class="px-6 py-4">{{ $control->owner ?? '-' }}</td>
                            <td class="px-6 py-4">{{ $control->review_date?->format('M d, Y') ?? '-' }}</td>
                            <td class="px-6 py-4 text-center">
                                <span class="px-2 py-1 text-xs rounded-full {{ $control->status==='active' ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800' }}">{{ ucfirst($control->status) }}</span>
                            </td>
                            <td class="px-6 py-4 text-right">
                                <form action="{{ url('finance/audit.access-controls.update', $control) }}" method="POST" class="inline-flex items-center space-x-2">
                                    @csrf
                                    @method('PUT')
                                    <select name="status" class="form-select text-sm">
                                        @foreach(['active','inactive'] as $s)
                                            <option value="{{ $s }}" {{ $control->status===$s ? 'selected' : '' }}>{{ ucfirst($s) }}</option>
                                        @endforeach
                                    </select>
                                    <button class="text-indigo-600 hover:text-indigo-900">Update</button>
                                </form>
                                <form action="{{ url('finance/audit.access-controls.destroy', $control) }}" method="POST" class="inline" onsubmit="return confirm('Delete control?')">
                                    @csrf
                                    @method('DELETE')
                                    <button class="text-red-600 hover:text-red-900 ml-3">Delete</button>
                                </form>
                            </td>
                        </tr>
                    @empty
                        <tr><td colspan="5" class="text-center py-10 text-gray-500">No access controls found.</td></tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="p-4">{{ $accessControls->links() }}</div>
    </div>

    <!-- New Control Modal -->
    <div x-show="showModal" @click.away="showModal = false" class="fixed inset-0 bg-gray-600 bg-opacity-50 h-full w-full z-50" x-cloak>
        <div class="relative top-10 mx-auto p-5 border w-full max-w-xl shadow-lg rounded-md bg-white">
            <form action="{{ url('finance/audit.access-controls.store') }}" method="POST">
                @csrf
                <h3 class="text-lg font-semibold mb-4">Create Access Control</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm">Title</label>
                        <input type="text" name="title" class="form-input" required placeholder="e.g., Admin Panel Access">
                    </div>
                    <div>
                        <label class="block text-sm">Owner</label>
                        <input type="text" name="owner" class="form-input" placeholder="Responsible person/department">
                    </div>
                    <div>
                        <label class="block text-sm">Review Date</label>
                        <input type="date" name="review_date" class="form-input">
                    </div>
                    <div class="md:col-span-2">
                        <label class="block text-sm">Notes</label>
                        <textarea name="notes" rows="2" class="form-input" placeholder="Additional details or restrictions..."></textarea>
                    </div>
                </div>
                <div class="flex justify-end space-x-2 mt-6">
                    <button type="button" @click="showModal = false" class="bg-gray-300 text-gray-700 px-4 py-2 rounded-lg">Close</button>
                    <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Create</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection



