@extends('layouts.admin')

@section('title', 'Compliance Cases')

@section('content')
<div class="p-6 lg:p-8" x-data="{ showModal: false }" @open-modal.window="showModal = true">
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-800">Compliance Cases</h1>
            <p class="text-sm text-gray-600">Track and manage compliance requirements.</p>
        </div>
        <button @click="showModal = true" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">New Case</button>
    </div>

    <!-- Cases Table -->
    <div class="bg-white rounded-lg shadow-md">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Title</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Regulation</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Owner</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Due Date</th>
                        <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase">Status</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($cases as $case)
                        <tr>
                            <td class="px-6 py-4">{{ $case->title }}</td>
                            <td class="px-6 py-4">{{ $case->regulation ?? '-' }}</td>
                            <td class="px-6 py-4">{{ $case->owner ?? '-' }}</td>
                            <td class="px-6 py-4">{{ $case->due_date?->format('M d, Y') ?? '-' }}</td>
                            <td class="px-6 py-4 text-center">
                                <span class="px-2 py-1 text-xs rounded-full {{ $case->status==='closed' ? 'bg-green-100 text-green-800' : ($case->status==='in_progress' ? 'bg-yellow-100 text-yellow-800' : 'bg-gray-100 text-gray-800') }}">{{ ucwords(str_replace('_',' ',$case->status)) }}</span>
                            </td>
                            <td class="px-6 py-4 text-right">
                                <form action="{{ url('finance/audit.compliance.update', $case) }}" method="POST" class="inline-flex items-center space-x-2">
                                    @csrf
                                    @method('PUT')
                                    <select name="status" class="form-select text-sm">
                                        @foreach(['open','in_progress','closed'] as $s)
                                            <option value="{{ $s }}" {{ $case->status===$s ? 'selected' : '' }}>{{ ucwords(str_replace('_',' ',$s)) }}</option>
                                        @endforeach
                                    </select>
                                    <button class="text-indigo-600 hover:text-indigo-900">Update</button>
                                </form>
                                <form action="{{ url('finance/audit.compliance.destroy', $case) }}" method="POST" class="inline" onsubmit="return confirm('Delete case?')">
                                    @csrf
                                    @method('DELETE')
                                    <button class="text-red-600 hover:text-red-900 ml-3">Delete</button>
                                </form>
                            </td>
                        </tr>
                    @empty
                        <tr><td colspan="6" class="text-center py-10 text-gray-500">No compliance cases found.</td></tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="p-4">{{ $cases->links() }}</div>
    </div>

    <!-- New Case Modal -->
    <div x-show="showModal" @click.away="showModal = false" class="fixed inset-0 bg-gray-600 bg-opacity-50 h-full w-full z-50" x-cloak>
        <div class="relative top-10 mx-auto p-5 border w-full max-w-xl shadow-lg rounded-md bg-white">
            <form action="{{ url('finance/audit.compliance.store') }}" method="POST">
                @csrf
                <h3 class="text-lg font-semibold mb-4">Create Compliance Case</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm">Title</label>
                        <input type="text" name="title" class="form-input" required>
                    </div>
                    <div>
                        <label class="block text-sm">Due Date</label>
                        <input type="date" name="due_date" class="form-input">
                    </div>
                    <div>
                        <label class="block text-sm">Regulation</label>
                        <input type="text" name="regulation" class="form-input" placeholder="e.g., GDPR, SOX">
                    </div>
                    <div>
                        <label class="block text-sm">Owner</label>
                        <input type="text" name="owner" class="form-input">
                    </div>
                    <div class="md:col-span-2">
                        <label class="block text-sm">Notes</label>
                        <textarea name="notes" rows="2" class="form-input"></textarea>
                    </div>
                </div>
                <div class="flex justify-end space-x-2 mt-6">
                    <button type="button" @click="showModal = false" class="bg-gray-300 text-gray-700 px-4 py-2 rounded-lg">Close</button>
                    <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Create</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection



