@extends('layouts.admin')

@section('title', 'Internal Audit Details')

@section('content')
<div class="p-6 lg:p-8" x-data="{ showFinding: false }" @open-finding.window="showFinding = true">
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-800">{{ $audit->title }}</h1>
            <p class="text-sm text-gray-600">Date: {{ $audit->audit_date->format('M d, Y') }} | Status: <span class="font-medium">{{ ucwords(str_replace('_',' ',$audit->status)) }}</span></p>
        </div>
        <a href="{{ url('finance/audit.internal-audit') }}" class="bg-white border px-4 py-2 rounded-md shadow-sm hover:bg-gray-50">Back</a>
    </div>

    <!-- Audit Summary / Update -->
    <div class="bg-white rounded-lg shadow-md p-6 mb-6">
        <form action="{{ url('finance/audit.internal-audit.update', $audit) }}" method="POST" class="grid grid-cols-1 md:grid-cols-3 gap-4">
            @csrf
            @method('PUT')
            <div>
                <label class="block text-sm">Title</label>
                <input type="text" name="title" class="form-input" value="{{ $audit->title }}" required>
            </div>
            <div>
                <label class="block text-sm">Audit Date</label>
                <input type="date" name="audit_date" class="form-input" value="{{ $audit->audit_date->format('Y-m-d') }}" required>
            </div>
            <div>
                <label class="block text-sm">Auditor</label>
                <input type="text" name="auditor" class="form-input" value="{{ $audit->auditor }}">
            </div>
            <div class="md:col-span-2">
                <label class="block text-sm">Scope</label>
                <input type="text" name="scope" class="form-input" value="{{ $audit->scope }}">
            </div>
            <div>
                <label class="block text-sm">Status</label>
                <select name="status" class="form-select">
                    @foreach(['open','in_progress','closed'] as $s)
                        <option value="{{ $s }}" {{ $audit->status===$s ? 'selected' : '' }}>{{ ucwords(str_replace('_',' ',$s)) }}</option>
                    @endforeach
                </select>
            </div>
            <div class="md:col-span-3">
                <label class="block text-sm">Notes</label>
                <textarea name="notes" rows="2" class="form-input">{{ $audit->notes }}</textarea>
            </div>
            <div class="md:col-span-3 flex justify-end">
                <button class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Update Audit</button>
            </div>
        </form>
    </div>

    <!-- Findings header -->
    <div class="flex justify-between items-center mb-3">
        <h2 class="text-lg font-semibold">Findings</h2>
        <button @click="showFinding = true" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Add Finding</button>
    </div>

    <!-- Findings Table -->
    <div class="bg-white rounded-lg shadow-md">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Title</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Severity</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Resolved</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($findings as $f)
                        <tr>
                            <td class="px-6 py-4">
                                <div class="font-medium">{{ $f->title }}</div>
                                <div class="text-xs text-gray-500">{{ $f->detail }}</div>
                            </td>
                            <td class="px-6 py-4">{{ ucfirst($f->severity) }}</td>
                            <td class="px-6 py-4">{{ $f->resolved ? 'Yes' : 'No' }}</td>
                            <td class="px-6 py-4 text-right">
                                @if(!$f->resolved)
                                <form action="{{ url('finance/audit.internal-audit.findings.resolve', $f) }}" method="POST" class="inline-flex space-x-2">
                                    @csrf
                                    @method('PUT')
                                    <input type="text" name="resolution_notes" placeholder="Resolution notes" class="form-input text-sm"/>
                                    <button class="text-indigo-600 hover:text-indigo-900">Mark Resolved</button>
                                </form>
                                @else
                                    <span class="text-xs text-gray-500">Resolved at {{ $f->resolved_at?->format('M d, Y H:i') }}</span>
                                @endif
                            </td>
                        </tr>
                    @empty
                        <tr><td colspan="4" class="text-center py-10 text-gray-500">No findings recorded.</td></tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="p-4">{{ $findings->links() }}</div>
    </div>

    <!-- Add Finding Modal -->
    <div x-show="showFinding" @click.away="showFinding = false" class="fixed inset-0 bg-gray-600 bg-opacity-50 h-full w-full z-50" x-cloak>
        <div class="relative top-10 mx-auto p-5 border w-full max-w-xl shadow-lg rounded-md bg-white">
            <form action="{{ url('finance/audit.internal-audit.findings.store', $audit) }}" method="POST">
                @csrf
                <h3 class="text-lg font-semibold mb-4">Add Finding</h3>
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm">Title</label>
                        <input type="text" name="title" class="form-input" required>
                    </div>
                    <div>
                        <label class="block text-sm">Detail</label>
                        <textarea name="detail" rows="2" class="form-input"></textarea>
                    </div>
                    <div>
                        <label class="block text-sm">Severity</label>
                        <select name="severity" class="form-select" required>
                            @foreach(['low','medium','high','critical'] as $s)
                                <option value="{{ $s }}">{{ ucfirst($s) }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="flex justify-end space-x-2 mt-6">
                    <button type="button" @click="showFinding = false" class="bg-gray-300 text-gray-700 px-4 py-2 rounded-lg">Close</button>
                    <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Save Finding</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection



