@extends('layouts.admin')

@section('title', 'Internal Audit Reports')

@section('content')
<div class="p-6 lg:p-8" x-data="{ showModal: false }" @open-modal.window="showModal = true">
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-800">Internal Audits</h1>
            <p class="text-sm text-gray-600">Create, track, and close internal audits and findings.</p>
        </div>
        <button @click="showModal = true" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">New Audit</button>
    </div>

    <!-- Filters -->
    <form method="GET" action="{{ url('finance/audit.internal-audit') }}" class="bg-white rounded-lg shadow-md p-4 mb-6 grid grid-cols-1 md:grid-cols-5 gap-4">
        <select name="status" class="form-select">
            <option value="">All Status</option>
            @foreach(['open','in_progress','closed'] as $s)
                <option value="{{ $s }}" {{ request('status')===$s ? 'selected' : '' }}>{{ ucwords(str_replace('_',' ',$s)) }}</option>
            @endforeach
        </select>
        <input type="date" name="start_date" value="{{ request('start_date') }}" class="form-input" placeholder="Start date">
        <input type="date" name="end_date" value="{{ request('end_date') }}" class="form-input" placeholder="End date">
        <input type="text" name="q" value="{{ request('q') }}" class="form-input" placeholder="Search title/scope">
        <button type="submit" class="bg-gray-800 text-white px-4 py-2 rounded-md">Apply</button>
    </form>

    <!-- Audits Table -->
    <div class="bg-white rounded-lg shadow-md">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Title</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Scope</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Date</th>
                        <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase">Status</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($audits as $audit)
                        <tr>
                            <td class="px-6 py-4">{{ $audit->title }}</td>
                            <td class="px-6 py-4">{{ $audit->scope ?? '-' }}</td>
                            <td class="px-6 py-4">{{ $audit->audit_date->format('M d, Y') }}</td>
                            <td class="px-6 py-4 text-center">
                                <span class="px-2 py-1 text-xs rounded-full {{ $audit->status==='closed' ? 'bg-green-100 text-green-800' : ($audit->status==='in_progress' ? 'bg-yellow-100 text-yellow-800' : 'bg-gray-100 text-gray-800') }}">{{ ucwords(str_replace('_',' ',$audit->status)) }}</span>
                            </td>
                            <td class="px-6 py-4 text-right">
                                <a href="{{ url('finance/audit.internal-audit.show', $audit) }}" class="text-indigo-600 hover:text-indigo-900">Open</a>
                                <form action="{{ url('finance/audit.internal-audit.destroy', $audit) }}" method="POST" class="inline" onsubmit="return confirm('Delete audit?')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="text-red-600 hover:text-red-900 ml-3">Delete</button>
                                </form>
                            </td>
                        </tr>
                    @empty
                        <tr><td colspan="5" class="text-center py-10 text-gray-500">No internal audits found.</td></tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="p-4">{{ $audits->links() }}</div>
    </div>

    <!-- New Audit Modal -->
    <div x-show="showModal" @click.away="showModal = false" class="fixed inset-0 bg-gray-600 bg-opacity-50 h-full w-full z-50" x-cloak>
        <div class="relative top-10 mx-auto p-5 border w-full max-w-xl shadow-lg rounded-md bg-white">
            <form action="{{ url('finance/audit.internal-audit.store') }}" method="POST">
                @csrf
                <h3 class="text-lg font-semibold mb-4">Create Internal Audit</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm">Title</label>
                        <input type="text" name="title" class="form-input" required>
                    </div>
                    <div>
                        <label class="block text-sm">Audit Date</label>
                        <input type="date" name="audit_date" class="form-input" required>
                    </div>
                    <div class="md:col-span-2">
                        <label class="block text-sm">Scope</label>
                        <input type="text" name="scope" class="form-input">
                    </div>
                    <div>
                        <label class="block text-sm">Auditor</label>
                        <input type="text" name="auditor" class="form-input">
                    </div>
                    <div class="md:col-span-2">
                        <label class="block text-sm">Notes</label>
                        <textarea name="notes" rows="2" class="form-input"></textarea>
                    </div>
                </div>
                <div class="flex justify-end space-x-2 mt-6">
                    <button type="button" @click="showModal = false" class="bg-gray-300 text-gray-700 px-4 py-2 rounded-lg">Close</button>
                    <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Create</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection



