@extends('layouts.admin')

@section('title', 'SOX Compliance')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-4 sm:mb-6">
        <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">SOX Compliance</h1>
        <p class="text-xs sm:text-sm text-gray-600 mt-1">Manage SOX controls: create, review, update status, and remove.</p>
    </div>

    @if(session('success'))
        <div class="mb-4 p-3 bg-green-50 border border-green-200 text-green-700 rounded">
            {{ session('success') }}
        </div>
    @endif
    @if($errors->any())
        <div class="mb-4 p-3 bg-red-50 border border-red-200 text-red-700 rounded">
            <ul class="list-disc ml-4">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6 mb-4 sm:mb-6">
        <h2 class="text-base sm:text-lg font-bold text-gray-900 mb-3 sm:mb-4">Create New Control</h2>
        <form method="POST" action="{{ route('admin.finance.audit.sox.store') }}" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-3 sm:gap-4">
            @csrf
            <div>
                <label class="block text-xs sm:text-sm text-gray-700 mb-1">Control Name<span class="text-red-500">*</span></label>
                <input type="text" name="control_name" required class="w-full border border-gray-300 rounded px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500" placeholder="e.g. Revenue Recognition">
            </div>
            <div>
                <label class="block text-xs sm:text-sm text-gray-700 mb-1">Framework</label>
                <input type="text" name="framework" value="SOX" class="w-full border border-gray-300 rounded px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500" placeholder="SOX">
            </div>
            <div>
                <label class="block text-xs sm:text-sm text-gray-700 mb-1">Owner</label>
                <input type="text" name="owner" class="w-full border border-gray-300 rounded px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500" placeholder="e.g. Finance Team">
            </div>
            <div>
                <label class="block text-xs sm:text-sm text-gray-700 mb-1">Test Date</label>
                <input type="date" name="test_date" class="w-full border border-gray-300 rounded px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>
            <div class="md:col-span-2 lg:col-span-3">
                <label class="block text-xs sm:text-sm text-gray-700 mb-1">Notes</label>
                <textarea name="notes" class="w-full border border-gray-300 rounded px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500" rows="3" placeholder="Add any relevant details..."></textarea>
            </div>
            <div class="md:col-span-2 lg:col-span-3">
                <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Create Control</button>
            </div>
        </form>
    </div>

    <div class="bg-white rounded-lg shadow-md overflow-hidden">
        <div class="px-3 sm:px-4 lg:px-6 py-3 sm:py-4 border-b border-gray-200">
            <div class="flex items-center justify-between">
                <h2 class="text-base sm:text-lg font-bold text-gray-900">Controls</h2>
                <span class="text-xs sm:text-sm text-gray-500">Total: {{ $controls->total() }}</span>
            </div>
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Control</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Framework</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Owner</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Status</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Test Date</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Notes</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($controls as $control)
                        <tr class="align-top">
                            <td class="px-4 py-2.5 whitespace-nowrap">
                                <div class="text-xs font-medium text-gray-900">{{ $control->control_name }}</div>
                                <div class="text-[10px] text-gray-500">#{{ $control->id }}</div>
                            </td>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-900">{{ $control->framework }}</td>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-900">{{ $control->owner ?? '—' }}</td>
                            <td class="px-4 py-2.5 whitespace-nowrap">
                                <span class="px-2 inline-flex text-[10px] leading-4 font-semibold rounded-full
                                    @if($control->status === 'active') bg-green-100 text-green-800 @elseif($control->status === 'inactive') bg-yellow-100 text-yellow-800 @else bg-gray-100 text-gray-800 @endif">
                                    {{ ucfirst($control->status) }}
                                </span>
                            </td>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-900">{{ optional($control->test_date)->format('Y-m-d') ?? '—' }}</td>
                            <td class="px-4 py-2.5 text-xs text-gray-900 max-w-xs truncate">
                                {{ $control->notes ?? '—' }}
                            </td>
                            <td class="px-4 py-2.5 whitespace-nowrap">
                                <div x-data="{ open: false }" class="inline-block">
                                    <button @click="open = !open" class="text-xs text-blue-600 hover:text-blue-800 font-medium">Edit</button>
                                    <form method="POST" action="{{ route('admin.finance.audit.sox.destroy', $control) }}" class="inline" onsubmit="return confirm('Delete this control?')">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="ml-3 text-xs text-red-600 hover:text-red-800 font-medium">Delete</button>
                                    </form>
                                    <div x-show="open" x-cloak class="mt-3 p-3 border rounded bg-gray-50">
                                        <form method="POST" action="{{ route('admin.finance.audit.sox.update', $control) }}" class="grid grid-cols-1 md:grid-cols-2 gap-3">
                                            @csrf
                                            @method('PUT')
                                            <div>
                                                <label class="block text-xs text-gray-600 mb-1">Control Name</label>
                                                <input type="text" name="control_name" value="{{ $control->control_name }}" class="w-full border rounded px-2 py-1">
                                            </div>
                                            <div>
                                                <label class="block text-xs text-gray-600 mb-1">Framework</label>
                                                <input type="text" name="framework" value="{{ $control->framework }}" class="w-full border rounded px-2 py-1">
                                            </div>
                                            <div>
                                                <label class="block text-xs text-gray-600 mb-1">Owner</label>
                                                <input type="text" name="owner" value="{{ $control->owner }}" class="w-full border rounded px-2 py-1">
                                            </div>
                                            <div>
                                                <label class="block text-xs text-gray-600 mb-1">Status</label>
                                                <select name="status" class="w-full border rounded px-2 py-1">
                                                    <option value="active" @selected($control->status==='active')>Active</option>
                                                    <option value="inactive" @selected($control->status==='inactive')>Inactive</option>
                                                    <option value="deprecated" @selected($control->status==='deprecated')>Deprecated</option>
                                                </select>
                                            </div>
                                            <div>
                                                <label class="block text-xs text-gray-600 mb-1">Test Date</label>
                                                <input type="date" name="test_date" value="{{ optional($control->test_date)->format('Y-m-d') }}" class="w-full border rounded px-2 py-1">
                                            </div>
                                            <div class="md:col-span-2">
                                                <label class="block text-xs text-gray-600 mb-1">Notes</label>
                                                <textarea name="notes" class="w-full border rounded px-2 py-1" rows="2">{{ $control->notes }}</textarea>
                                            </div>
                                            <div class="md:col-span-2">
                                                <button type="submit" class="px-3 py-1 bg-blue-600 text-white rounded text-xs">Update</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="px-4 py-3 text-center text-xs text-gray-500">No controls found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="px-3 sm:px-4 lg:px-6 py-3">{{ $controls->links() }}</div>
    </div>
</div>
@endsection
