@extends('layouts.admin')

@section('title', 'Bank Accounts')

@section('content')
<div class="p-6 lg:p-8" x-data="{ showModal: false }" @open-modal.window="showModal = true">
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-800">Bank Accounts</h1>
            <p class="text-sm text-gray-600">Manage all linked bank accounts.</p>
        </div>
        <button @click="showModal = true" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Add New Account</button>
    </div>

    <!-- Accounts Table -->
    <div class="bg-white rounded-lg shadow-md">
        <div class="p-4 border-b">
            <h3 class="text-lg font-semibold">All Bank Accounts</h3>
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Bank Name</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Account Number</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Branch</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Balance</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($accounts as $account)
                        <tr>
                            <td class="px-6 py-4 text-sm font-medium">{{ $account->bank_name }}</td>
                            <td class="px-6 py-4 text-sm">{{ $account->account_number }}</td>
                            <td class="px-6 py-4 text-sm">{{ $account->branch }}</td>
                            <td class="px-6 py-4 text-sm">Rs. {{ number_format($account->balance, 2) }}</td>
                            <td class="px-6 py-4 text-sm">
                                <a href="{{ url('finance/banking.accounts.edit', $account) }}" class="text-indigo-600 hover:text-indigo-900">Edit</a>
                                <form action="{{ url('finance/banking.accounts.destroy', $account) }}" method="POST" class="inline" onsubmit="return confirm('Are you sure?')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="text-red-600 hover:text-red-900 ml-2">Delete</button>
                                </form>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="text-center py-10">No bank accounts found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="p-4">{{ $accounts->links() }}</div>
    </div>
    <!-- Add Bank Account Modal -->
    <div x-show="showModal" @click.away="showModal = false" class="fixed inset-0 bg-gray-600 bg-opacity-50 h-full w-full z-50" x-cloak>
        <div class="relative top-20 mx-auto p-5 border w-full max-w-lg shadow-lg rounded-md bg-white">
            <h3 class="text-lg font-semibold mb-4">Add New Bank Account</h3>
            <form action="{{ url('finance/banking.accounts.store') }}" method="POST">
                @csrf
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm">Bank Name</label>
                        <input type="text" name="bank_name" class="form-input" required>
                    </div>
                    <div>
                        <label class="block text-sm">Account Holder Name</label>
                        <input type="text" name="account_name" class="form-input" required>
                    </div>
                    <div>
                        <label class="block text-sm">Account Number</label>
                        <input type="text" name="account_number" class="form-input" required>
                    </div>
                    <div>
                        <label class="block text-sm">Branch</label>
                        <input type="text" name="branch" class="form-input" required>
                    </div>
                    <div>
                        <label class="block text-sm">IFSC Code</label>
                        <input type="text" name="ifsc_code" class="form-input" required>
                    </div>
                </div>
                <div class="flex justify-end space-x-2 mt-6">
                    <button type="button" @click="showModal = false" class="bg-gray-300 text-gray-700 px-4 py-2 rounded-lg hover:bg-gray-400">Close</button>
                    <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Save Account</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection



