@extends('layouts.admin')

@section('title', 'Edit Bank Account')

@section('content')
<div class="p-6 lg:p-8">
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-800">Edit Bank Account</h1>
            <p class="text-sm text-gray-600">Update bank account details.</p>
        </div>
        <a href="{{ url('finance/banking.accounts') }}" class="bg-white text-gray-700 px-4 py-2 rounded-lg border shadow-sm hover:bg-gray-50">Back</a>
    </div>

    <div class="bg-white rounded-lg shadow-md p-6">
        <form action="{{ url('finance/banking.accounts.update', $bankAccount) }}" method="POST">
            @csrf
            @method('PUT')
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Bank Name</label>
                    <input type="text" name="bank_name" value="{{ $bankAccount->bank_name }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                </div>
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Account Name</label>
                    <input type="text" name="account_name" value="{{ $bankAccount->account_name }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                </div>
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Account Number</label>
                    <input type="text" name="account_number" value="{{ $bankAccount->account_number }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                </div>
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Branch</label>
                    <input type="text" name="branch" value="{{ $bankAccount->branch }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                </div>
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">IFSC Code</label>
                    <input type="text" name="ifsc_code" value="{{ $bankAccount->ifsc_code }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                </div>
            </div>
            <div class="flex justify-end mt-6">
                <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Update Account</button>
            </div>
        </form>
    </div>
</div>
@endsection


