@extends('layouts.admin')

@section('title', 'Reconciliation Details')

@section('content')
<div class="p-6 lg:p-8">
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-800">Reconciliation: {{ $rec->bank_name }} ({{ $rec->statement_period }})</h1>
            <p class="text-sm text-gray-600">Uploaded on {{ $rec->uploaded_at->format('M d, Y') }}</p>
        </div>
        <a href="{{ url('finance/banking.reconciliation') }}" class="bg-white border px-4 py-2 rounded-md shadow-sm hover:bg-gray-50">Back</a>
    </div>

    <!-- Filters -->
    <form method="GET" class="bg-white rounded-lg shadow-md p-4 mb-6 grid grid-cols-1 md:grid-cols-4 gap-4">
        <select name="status" class="form-select">
            <option value="">All</option>
            <option value="matched" {{ request('status')==='matched' ? 'selected' : '' }}>Matched</option>
            <option value="unmatched" {{ request('status')==='unmatched' ? 'selected' : '' }}>Unmatched</option>
        </select>
        <button class="bg-gray-800 text-white px-4 py-2 rounded-md" type="submit">Apply</button>
    </form>

    <!-- Lines Table -->
    <div class="bg-white rounded-lg shadow-md">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Date</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Description</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Amount</th>
                        <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase">Status</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($lines as $line)
                        <tr>
                            <td class="px-6 py-4">{{ $line->txn_date->format('M d, Y') }}</td>
                            <td class="px-6 py-4">{{ $line->description }}</td>
                            <td class="px-6 py-4 text-right">{{ number_format($line->amount, 2) }}</td>
                            <td class="px-6 py-4 text-center">
                                <span class="px-2 py-1 text-xs rounded-full {{ $line->is_matched ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800' }}">
                                    {{ $line->is_matched ? 'Matched' : 'Unmatched' }}
                                </span>
                            </td>
                            <td class="px-6 py-4 text-right">
                                <form action="{{ url('finance/banking.reconciliation.line.match', $line) }}" method="POST" class="inline">
                                    @csrf
                                    @method('PUT')
                                    <button class="text-indigo-600 hover:text-indigo-900" type="submit">
                                        {{ $line->is_matched ? 'Unmatch' : 'Mark Matched' }}
                                    </button>
                                </form>
                            </td>
                        </tr>
                    @empty
                        <tr><td colspan="5" class="text-center py-10 text-gray-500">No transactions found.</td></tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="p-4">{{ $lines->appends(request()->query())->links() }}</div>
    </div>
</div>
@endsection



