@extends('layouts.admin')

@section('title', 'Edit Deposit - Finance')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6 max-w-4xl">
    <!-- Header -->
    <div class="mb-4 sm:mb-6">
        <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center gap-3">
            <div>
                <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Edit Deposit</h1>
                <p class="text-xs sm:text-sm text-gray-600 mt-1">Update deposit information</p>
            </div>
            <div class="flex gap-2 w-full sm:w-auto">
                <a href="{{ url('finance/cod.deposits') }}" class="flex-1 sm:flex-none bg-gray-600 text-white px-3 sm:px-4 py-2 rounded-md hover:bg-gray-700 text-xs sm:text-sm text-center">
                    Back to Deposits
                </a>
                <a href="{{ url('finance/cod.deposits.show', $deposit->id) }}" class="flex-1 sm:flex-none bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md hover:bg-blue-700 text-xs sm:text-sm text-center">
                    View Deposit
                </a>
            </div>
        </div>
    </div>

    @if($errors->any())
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert">
            <strong class="font-bold">Whoops!</strong>
            <span class="block sm:inline">There were some problems with your input.</span>
            <ul class="mt-2 list-disc list-inside text-sm">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <!-- Form -->
    <div class="bg-white rounded-lg shadow-md p-4 sm:p-6 lg:p-8">
        <form method="POST" action="{{ url('finance/cod.deposits.update', $deposit->id) }}">
            @csrf
            @method('PUT')

            <!-- Deposit Information -->
            <div class="mb-6">
                <h2 class="text-lg sm:text-base sm:text-lg font-semibold text-gray-800 mb-4 pb-2 border-b">Deposit Information</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label for="bank_name" class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">
                            Bank Name <span class="text-red-500">*</span>
                        </label>
                        <select name="bank_name" id="bank_name" required class="w-full px-3 py-2 text-xs sm:text-sm border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <option value="">Select Bank</option>
                            <option value="HBL" {{ $deposit->bank_name == 'HBL' ? 'selected' : '' }}>HBL - Habib Bank Limited</option>
                            <option value="UBL" {{ $deposit->bank_name == 'UBL' ? 'selected' : '' }}>UBL - United Bank Limited</option>
                            <option value="MCB" {{ $deposit->bank_name == 'MCB' ? 'selected' : '' }}>MCB - Muslim Commercial Bank</option>
                            <option value="Allied Bank" {{ $deposit->bank_name == 'Allied Bank' ? 'selected' : '' }}>Allied Bank</option>
                            <option value="Meezan Bank" {{ $deposit->bank_name == 'Meezan Bank' ? 'selected' : '' }}>Meezan Bank</option>
                            <option value="Askari Bank" {{ $deposit->bank_name == 'Askari Bank' ? 'selected' : '' }}>Askari Bank</option>
                            <option value="Bank Alfalah" {{ $deposit->bank_name == 'Bank Alfalah' ? 'selected' : '' }}>Bank Alfalah</option>
                            <option value="Faysal Bank" {{ $deposit->bank_name == 'Faysal Bank' ? 'selected' : '' }}>Faysal Bank</option>
                        </select>
                    </div>

                    <div>
                        <label for="amount" class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">
                            Amount (Rs.) <span class="text-red-500">*</span>
                        </label>
                        <input type="number" name="amount" id="amount" value="{{ $deposit->amount }}" step="0.01" min="0" required
                               class="w-full px-3 py-2 text-xs sm:text-sm border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                        @error('amount')
                            <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label for="reference_number" class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">
                            Reference Number <span class="text-red-500">*</span>
                        </label>
                        <input type="text" name="reference_number" id="reference_number" value="{{ $deposit->reference_number }}" required
                               class="w-full px-3 py-2 text-xs sm:text-sm border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                        @error('reference_number')
                            <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label for="payment_date" class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">
                            Deposit Date <span class="text-red-500">*</span>
                        </label>
                        <input type="date" name="payment_date" id="payment_date" value="{{ $deposit->payment_date->format('Y-m-d') }}" required
                               class="w-full px-3 py-2 text-xs sm:text-sm border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                        @error('payment_date')
                            <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label for="payment_method" class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">
                            Payment Method <span class="text-red-500">*</span>
                        </label>
                        <select name="payment_method" id="payment_method" required class="w-full px-3 py-2 text-xs sm:text-sm border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <option value="bank_transfer" {{ $deposit->payment_method == 'bank_transfer' ? 'selected' : '' }}>Bank Transfer</option>
                            <option value="cash" {{ $deposit->payment_method == 'cash' ? 'selected' : '' }}>Cash</option>
                            <option value="cheque" {{ $deposit->payment_method == 'cheque' ? 'selected' : '' }}>Cheque</option>
                            <option value="online" {{ $deposit->payment_method == 'online' ? 'selected' : '' }}>Online</option>
                        </select>
                        @error('payment_method')
                            <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label for="status" class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">
                            Status <span class="text-red-500">*</span>
                        </label>
                        <select name="status" id="status" required class="w-full px-3 py-2 text-xs sm:text-sm border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <option value="pending" {{ $deposit->status == 'pending' ? 'selected' : '' }}>Pending</option>
                            <option value="completed" {{ $deposit->status == 'completed' ? 'selected' : '' }}>Completed</option>
                            <option value="failed" {{ $deposit->status == 'failed' ? 'selected' : '' }}>Failed</option>
                            <option value="cancelled" {{ $deposit->status == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                        </select>
                        @error('status')
                            <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                        @enderror
                    </div>
                </div>

                <div class="mt-4">
                    <label for="notes" class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">
                        Notes
                    </label>
                    <textarea name="notes" id="notes" rows="3" class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500">{{ $deposit->notes }}</textarea>
                    @error('notes')
                        <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                    @enderror
                </div>
            </div>

            <!-- Deposit Status Information -->
            <div class="mb-6">
                <h2 class="text-lg sm:text-base sm:text-lg font-semibold text-gray-800 mb-4 pb-2 border-b">Status Information</h2>
                <div class="bg-gray-50 p-4 rounded-md">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 text-sm">
                        <div>
                            <p class="text-gray-600">Created:</p>
                            <p class="font-medium">{{ $deposit->created_at->format('M d, Y h:i A') }}</p>
                        </div>
                        <div>
                            <p class="text-gray-600">Last Updated:</p>
                            <p class="font-medium">{{ $deposit->updated_at->format('M d, Y h:i A') }}</p>
                        </div>
                        <div>
                            <p class="text-gray-600">Current Status:</p>
                            <span class="px-2 py-1 text-xs font-semibold rounded-full
                                @if($deposit->status === 'completed') bg-green-100 text-green-800
                                @elseif($deposit->status === 'pending') bg-yellow-100 text-yellow-800
                                @elseif($deposit->status === 'failed') bg-red-100 text-red-800
                                @else bg-gray-100 text-gray-800
                                @endif">
                                {{ ucfirst($deposit->status) }}
                            </span>
                        </div>
                        @if($deposit->merchant)
                        <div>
                            <p class="text-gray-600">Merchant:</p>
                            <p class="font-medium">{{ $deposit->merchant->name }}</p>
                        </div>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Action Buttons -->
            <div class="flex flex-col sm:flex-row justify-end gap-3 pt-4 border-t">
                <a href="{{ url('finance/cod.deposits') }}" class="px-6 py-2 border border-gray-300 rounded-md text-gray-700 hover:bg-gray-50 text-center text-xs sm:text-sm">
                    Cancel
                </a>
                <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">
                    Update Deposit
                </button>
            </div>
        </form>
    </div>
</div>
@endsection

