@extends('layouts.admin')

@section('title', 'View Deposit - Finance')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6 max-w-4xl">
    <!-- Header -->
    <div class="mb-4 sm:mb-6">
        <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center gap-3">
            <div>
                <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Deposit Details</h1>
                <p class="text-xs sm:text-sm text-gray-600 mt-1">View complete deposit information</p>
            </div>
            <div class="flex gap-2 w-full sm:w-auto">
                <a href="{{ url('finance/cod.deposits') }}" class="flex-1 sm:flex-none bg-gray-600 text-white px-3 sm:px-4 py-2 rounded-md hover:bg-gray-700 text-xs sm:text-sm text-center">
                    Back to Deposits
                </a>
                <a href="{{ url('finance/cod.deposits.edit', $deposit->id) }}" class="flex-1 sm:flex-none bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md hover:bg-blue-700 text-xs sm:text-sm text-center">
                    Edit Deposit
                </a>
            </div>
        </div>
    </div>

    <!-- Deposit Info Card -->
    <div class="bg-white rounded-lg shadow-md p-4 sm:p-6 mb-4 sm:mb-6">
        <div class="flex items-center gap-4 mb-4">
            <div class="h-12 w-12 rounded-full bg-green-100 flex items-center justify-center">
                <svg class="h-6 w-6 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                </svg>
            </div>
            <div>
                <h2 class="text-lg sm:text-base sm:text-lg font-bold text-gray-900">{{ $deposit->reference_number }}</h2>
                <p class="text-sm text-gray-600">{{ $deposit->bank_name }} Deposit</p>
            </div>
            <div class="ml-auto">
                <span class="px-3 py-1 text-sm font-semibold rounded-full
                    @if($deposit->status === 'completed') bg-green-100 text-green-800
                    @elseif($deposit->status === 'pending') bg-yellow-100 text-yellow-800
                    @elseif($deposit->status === 'failed') bg-red-100 text-red-800
                    @else bg-gray-100 text-gray-800
                    @endif">
                    {{ ucfirst($deposit->status) }}
                </span>
            </div>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div>
                <h3 class="text-sm font-semibold text-gray-800 mb-3">Deposit Information</h3>
                <div class="space-y-2 text-sm">
                    <div class="flex justify-between">
                        <span class="text-gray-600">Amount:</span>
                        <span class="font-semibold">Rs. {{ number_format($deposit->amount, 2) }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-600">Bank:</span>
                        <span>{{ $deposit->bank_name }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-600">Reference:</span>
                        <span>{{ $deposit->reference_number }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-600">Deposit Date:</span>
                        <span>{{ $deposit->payment_date->format('M d, Y') }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-600">Payment Method:</span>
                        <span>{{ ucfirst(str_replace('_', ' ', $deposit->payment_method)) }}</span>
                    </div>
                </div>
            </div>

            <div>
                <h3 class="text-sm font-semibold text-gray-800 mb-3">Additional Details</h3>
                <div class="space-y-2 text-sm">
                    <div class="flex justify-between">
                        <span class="text-gray-600">Created:</span>
                        <span>{{ $deposit->created_at->format('M d, Y H:i') }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-600">Last Updated:</span>
                        <span>{{ $deposit->updated_at->format('M d, Y H:i') }}</span>
                    </div>
                    @if($deposit->merchant)
                    <div class="flex justify-between">
                        <span class="text-gray-600">Merchant:</span>
                        <span>{{ $deposit->merchant->name }}</span>
                    </div>
                    @endif
                </div>

                @if($deposit->notes)
                <div class="mt-4">
                    <h4 class="text-sm font-semibold text-gray-800 mb-2">Notes</h4>
                    <p class="text-sm text-gray-600 bg-gray-50 p-2 rounded">{{ $deposit->notes }}</p>
                </div>
                @endif
            </div>
        </div>
    </div>

    <!-- Actions -->
    <div class="flex flex-col sm:flex-row gap-3">
        @if($deposit->status === 'pending')
        <button onclick="verifyDeposit({{ $deposit->id }})" class="flex-1 bg-green-600 text-white px-4 py-2 rounded-md hover:bg-green-700 text-sm font-medium">
            <svg class="w-4 h-4 mr-2 inline" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
            </svg>
            Verify Deposit
        </button>
        @endif
        <a href="{{ url('finance/cod.deposits.edit', $deposit->id) }}" class="flex-1 bg-blue-600 text-white px-4 py-2 rounded-md hover:bg-blue-700 text-sm font-medium text-center">
            Edit Deposit
        </a>
        <a href="{{ url('finance/cod.deposits') }}" class="flex-1 bg-gray-600 text-white px-4 py-2 rounded-md hover:bg-gray-700 text-sm font-medium text-center">
            Back to List
        </a>
    </div>
</div>

<script>
function verifyDeposit(id) {
    if(confirm('Are you sure you want to verify this deposit? This will mark it as completed.')) {
        fetch(`/admin/finance/cod/deposits/${id}/verify`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            }
        })
        .then(response => response.json())
        .then(data => {
            if(data.success) {
                alert('Deposit verified successfully!');
                location.reload();
            } else {
                alert('Error verifying deposit: ' + data.message);
            }
        })
        .catch(error => {
            alert('Error verifying deposit');
            console.error('Error:', error);
        });
    }
}
</script>
@endsection

