@extends('layouts.admin')

@section('title', 'Pending COD Report - Finance')
@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <!-- Header with Date Filter & Export -->
    <div class="mb-4 sm:mb-6">
        <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between gap-4">
            <div>
                <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Pending COD Report</h1>
                <p class="text-xs sm:text-sm text-gray-600 mt-1">All pending COD collections as of <span id="reportDate">{{ \Carbon\Carbon::parse($date)->format('F jS, Y') }}</span></p>
            </div>
            <div class="flex flex-col sm:flex-row gap-2 sm:gap-3">
                <div class="relative">
                    <input type="date" id="dateFilter" value="{{ $date }}"
                           class="pl-10 pr-3 py-2 border border-gray-300 rounded-md text-sm focus:outline-none focus:ring-2 focus:ring-blue-500"
                           onchange="updateReport(this.value)">
                    <svg class="w-5 h-5 text-gray-400 absolute left-3 top-2.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                    </svg>
                </div>
                <button onclick="exportReport()" class="inline-flex items-center px-4 py-2 bg-white border border-gray-300 rounded-md hover:bg-gray-50 text-sm font-medium">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                    </svg>
                    Export Report
                </button>
            </div>
        </div>
    </div>

    <script>
    function updateReport(date) {
        const dateObj = new Date(date);
        const options = { year: 'numeric', month: 'long', day: 'numeric' };
        document.getElementById('reportDate').textContent = dateObj.toLocaleDateString('en-US', options);
        window.location.href = `?date=${date}`;
    }

    function exportReport() {
        const date = document.getElementById('dateFilter').value;
        window.location.href = `/admin/finance/cod/pending-report/export?date=${date}`;
    }
    </script>

    <!-- Stats Cards -->
    <div class="grid grid-cols-2 lg:grid-cols-4 gap-3 sm:gap-4 mb-4 sm:mb-6">
        <div class="bg-white rounded-lg shadow-md p-3 sm:p-4">
            <p class="text-[10px] sm:text-xs text-gray-600">Total Pending</p>
            <p class="text-lg sm:text-2xl font-bold text-red-600">Rs. {{ number_format($stats['total_pending']) }}</p>
        </div>
        <div class="bg-white rounded-lg shadow-md p-3 sm:p-4">
            <p class="text-[10px] sm:text-xs text-gray-600">Pending Parcels</p>
            <p class="text-lg sm:text-2xl font-bold text-gray-900">{{ $stats['pending_parcels'] }}</p>
        </div>
        <div class="bg-white rounded-lg shadow-md p-3 sm:p-4">
            <p class="text-[10px] sm:text-xs text-gray-600">Overdue</p>
            <p class="text-lg sm:text-2xl font-bold text-orange-600">Rs. {{ number_format($stats['overdue']) }}</p>
        </div>
        <div class="bg-white rounded-lg shadow-md p-3 sm:p-4">
            <p class="text-[10px] sm:text-xs text-gray-600">Today's Due</p>
            <p class="text-lg sm:text-2xl font-bold text-yellow-600">Rs. {{ number_format($stats['today_due']) }}</p>
        </div>
    </div>

    <!-- Filters -->
    <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 mb-4 sm:mb-6">
        <div class="grid grid-cols-1 sm:grid-cols-3 gap-3">
            <input type="text" placeholder="Search by tracking ID..." class="px-3 py-2 border rounded-md text-sm">
            <select class="px-3 py-2 border rounded-md text-sm">
                <option>All Riders</option>
                <option>Rider 1</option>
                <option>Rider 2</option>
            </select>
            <select class="px-3 py-2 border rounded-md text-sm">
                <option>All Status</option>
                <option>Pending</option>
                <option>Overdue</option>
            </select>
        </div>
    </div>

    <!-- Pending COD Table -->
    <div class="bg-white rounded-lg shadow-md overflow-hidden">
        <div class="p-4 border-b">
            <h2 class="text-base sm:text-lg font-semibold">Pending Collections</h2>
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Tracking ID</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Rider</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Amount</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Days Pending</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <tr>
                        <td colspan="6" class="px-6 py-12 text-center text-gray-500">
                            <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                            </svg>
                            <p class="mt-4">No pending COD collections</p>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
