@extends('layouts.admin')

@section('title', 'COD Variance Report - Finance')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <!-- Header with Date Filter & Export -->
    <div class="mb-4 sm:mb-6">
        <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between gap-4">
            <div>
                <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">COD Variance Report</h1>
                <p class="text-xs sm:text-sm text-gray-600 mt-1">COD collection variances as of <span id="reportDate">{{ \Carbon\Carbon::parse($date)->format('F jS, Y') }}</span></p>
            </div>
            <div class="flex flex-col sm:flex-row gap-2 sm:gap-3">
                <div class="relative">
                    <input type="date" id="dateFilter" value="{{ $date }}"
                           class="pl-10 pr-3 py-2 border border-gray-300 rounded-md text-sm focus:outline-none focus:ring-2 focus:ring-blue-500"
                           onchange="updateReport(this.value)">
                    <svg class="w-5 h-5 text-gray-400 absolute left-3 top-2.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                    </svg>
                </div>
                <button onclick="exportReport()" class="inline-flex items-center px-4 py-2 bg-white border border-gray-300 rounded-md hover:bg-gray-50 text-sm font-medium">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                    </svg>
                    Export Report
                </button>
            </div>
        </div>
    </div>

    <script>
    function updateReport(date) {
        const dateObj = new Date(date);
        const options = { year: 'numeric', month: 'long', day: 'numeric' };
        document.getElementById('reportDate').textContent = dateObj.toLocaleDateString('en-US', options);
        window.location.href = `?date=${date}`;
    }

    function exportReport() {
        const date = document.getElementById('dateFilter').value;
        window.location.href = `/admin/finance/cod/variance-report/export?date=${date}`;
    }
    </script>

    <!-- Stats Cards -->
    <div class="grid grid-cols-2 lg:grid-cols-4 gap-3 sm:gap-4 mb-4 sm:mb-6">
        <div class="bg-white rounded-lg shadow-md p-3 sm:p-4">
            <p class="text-[10px] sm:text-xs text-gray-600">Total Variance</p>
            <p class="text-lg sm:text-2xl font-bold text-red-600">Rs. {{ number_format($stats['total_variance']) }}</p>
        </div>
        <div class="bg-white rounded-lg shadow-md p-3 sm:p-4">
            <p class="text-[10px] sm:text-xs text-gray-600">Cases</p>
            <p class="text-lg sm:text-2xl font-bold text-gray-900">{{ $stats['cases'] }}</p>
        </div>
        <div class="bg-white rounded-lg shadow-md p-3 sm:p-4">
            <p class="text-[10px] sm:text-xs text-gray-600">Resolved</p>
            <p class="text-lg sm:text-2xl font-bold text-green-600">Rs. {{ number_format($stats['resolved']) }}</p>
        </div>
        <div class="bg-white rounded-lg shadow-md p-3 sm:p-4">
            <p class="text-[10px] sm:text-xs text-gray-600">Pending</p>
            <p class="text-lg sm:text-2xl font-bold text-orange-600">Rs. {{ number_format($stats['pending']) }}</p>
        </div>
    </div>

    <!-- Variance Table -->
    <div class="bg-white rounded-lg shadow-md overflow-hidden">
        <div class="p-4 border-b">
            <h2 class="text-base sm:text-lg font-semibold">Variance Cases</h2>
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Date</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Rider</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Expected</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Collected</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Variance</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <tr>
                        <td colspan="7" class="px-6 py-12 text-center text-gray-500">
                            <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"/>
                            </svg>
                            <p class="mt-4">No variance cases found</p>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
