@extends('layouts.admin')

@section('title', 'Finance Dashboard')

@section('content')
<div class="space-y-6">
    <!-- Stats Cards -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
        <div class="bg-white p-6 rounded-lg shadow-sm">
            <h4 class="text-sm font-medium text-gray-500">Total Merchants</h4>
            <p class="text-3xl font-bold mt-2">{{ $stats['total_merchants'] }}</p>
        </div>
        <div class="bg-white p-6 rounded-lg shadow-sm">
            <h4 class="text-sm font-medium text-gray-500">Total Invoices</h4>
            <p class="text-3xl font-bold mt-2">{{ $stats['total_invoices'] }}</p>
        </div>
        <div class="bg-white p-6 rounded-lg shadow-sm">
            <h4 class="text-sm font-medium text-gray-500">Pending Payments</h4>
            <p class="text-3xl font-bold mt-2">{{ $stats['pending_payments'] }}</p>
        </div>
        <div class="bg-white p-6 rounded-lg shadow-sm">
            <h4 class="text-sm font-medium text-gray-500">Overdue Invoices</h4>
            <p class="text-3xl font-bold mt-2 text-red-600">{{ $stats['overdue_invoices'] }}</p>
        </div>
    </div>

    <!-- Recent Invoices and Payments -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <div class="bg-white p-6 rounded-lg shadow-sm">
            <h3 class="text-lg font-semibold mb-4">Recent Invoices</h3>
            <div class="overflow-x-auto">
                <table class="min-w-full text-sm">
                    <thead>
                        <tr class="text-left text-gray-500">
                            <th class="py-2 px-3 font-medium">Invoice #</th>
                            <th class="py-2 px-3 font-medium">Merchant</th>
                            <th class="py-2 px-3 font-medium">Amount</th>
                            <th class="py-2 px-3 font-medium">Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($recentInvoices as $invoice)
                            <tr class="border-b">
                                <td class="py-2 px-3">{{ $invoice->invoice_number }}</td>
                                <td class="py-2 px-3">{{ $invoice->merchant->name }}</td>
                                <td class="py-2 px-3">PKR {{ number_format($invoice->total_amount, 2) }}</td>
                                <td class="py-2 px-3"><span class="px-2 py-1 text-xs font-semibold rounded-full bg-blue-100 text-blue-800">{{ ucfirst($invoice->status) }}</span></td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="4" class="text-center py-4 text-gray-500">No recent invoices.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>

        <div class="bg-white p-6 rounded-lg shadow-sm">
            <h3 class="text-lg font-semibold mb-4">Recent Payments</h3>
            <div class="overflow-x-auto">
                <table class="min-w-full text-sm">
                    <thead>
                        <tr class="text-left text-gray-500">
                            <th class="py-2 px-3 font-medium">Merchant</th>
                            <th class="py-2 px-3 font-medium">Amount</th>
                            <th class="py-2 px-3 font-medium">Date</th>
                            <th class="py-2 px-3 font-medium">Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($recentPayments as $payment)
                            <tr class="border-b">
                                <td class="py-2 px-3">{{ $payment->merchant->name }}</td>
                                <td class="py-2 px-3">PKR {{ number_format($payment->amount, 2) }}</td>
                                <td class="py-2 px-3">{{ $payment->payment_date->format('d M, Y') }}</td>
                                <td class="py-2 px-3"><span class="px-2 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-800">{{ ucfirst($payment->status) }}</span></td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="4" class="text-center py-4 text-gray-500">No recent payments.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection


