@extends('layouts.admin')

@section('title', 'Edit Expense')

@section('content')
<div class="container mx-auto px-4 py-6">
    <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900 mb-4 sm:mb-6">Edit Expense</h1>

    <form method="POST" action="{{ url('finance/expenses.update', $expense) }}" enctype="multipart/form-data" class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6 space-y-4">
        @csrf
        @method('PUT')

        <div class="grid grid-cols-1 sm:grid-cols-3 gap-4">
            <div>
                <label class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">Category</label>
                <select name="expense_category" class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500">
                    @foreach(['office_supplies','utilities','rent','salary','marketing','travel','maintenance','other'] as $cat)
                        <option value="{{ $cat }}" {{ $expense->category === $cat ? 'selected' : '' }}>{{ ucwords(str_replace('_',' ', $cat)) }}</option>
                    @endforeach
                </select>
            </div>
            <div>
                <label class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">Amount</label>
                <input type="number" step="0.01" name="amount" value="{{ old('amount', $expense->amount) }}" class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500" required>
            </div>
            <div>
                <label class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">Expense Date</label>
                <input type="date" name="expense_date" value="{{ old('expense_date', optional($expense->expense_date)->format('Y-m-d')) }}" class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500" required>
            </div>
        </div>

        <div class="grid grid-cols-1 sm:grid-cols-2 gap-3 sm:gap-4">
            <div>
                <label class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">Vendor</label>
                <select name="vendor_id" class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <option value="">—</option>
                    @foreach(($vendors ?? []) as $vendor)
                        <option value="{{ $vendor->id }}" {{ $expense->vendor_id == $vendor->id ? 'selected' : '' }}>{{ $vendor->name }}</option>
                    @endforeach
                </select>
            </div>
            <div>
                <label class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">Receipt</label>
                <input type="file" name="receipt" class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500">
                @if($expense->receipt)
                <p class="text-xs text-gray-500 mt-1">Current: {{ $expense->receipt }}</p>
                @endif
            </div>
        </div>

        <div>
            <label class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">Description</label>
            <textarea name="description" rows="3" class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500">{{ old('description', $expense->description) }}</textarea>
        </div>

        <div class="flex items-center justify-end gap-2 sm:gap-3">
            <a href="{{ url('finance/expenses.company') }}" class="px-3 sm:px-4 py-2 border border-gray-300 rounded-md text-xs sm:text-sm font-semibold text-gray-700 hover:bg-gray-50 transition">Cancel</a>
            <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Update</button>
        </div>
    </form>
</div>
@endsection


