@extends('layouts.admin')

@section('title', 'Vendor Payments')

@section('content')
<div class="p-6 lg:p-8">
    <!-- Page Header -->
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-800">Vendor Payments</h1>
            <p class="text-sm text-gray-600">Track all payments made to vendors.</p>
        </div>
    </div>

    <!-- Filters -->
    <form method="GET" action="{{ url('finance/expenses.vendor-payments') }}" class="bg-white rounded-lg shadow-md p-4 mb-6 grid grid-cols-1 md:grid-cols-4 gap-4">
        <select name="vendor_id" class="form-select">
            <option value="">All Vendors</option>
            {{-- @foreach($vendors as $vendor)
                <option value="{{ $vendor->id }}" {{ request('vendor_id') == $vendor->id ? 'selected' : '' }}>{{ $vendor->name }}</option>
            @endforeach --}}
        </select>
        <input type="date" name="start_date" value="{{ request('start_date') }}" class="form-input">
        <input type="date" name="end_date" value="{{ request('end_date') }}" class="form-input">
        <button type="submit" class="bg-gray-800 text-white px-4 py-2 rounded-md">Filter</button>
    </form>

    <!-- Payments Table -->
    <div class="bg-white rounded-lg shadow-md">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Vendor</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Date</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Title</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Amount</th>
                        <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase">Status</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($expenses as $expense)
                        <tr>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs">{{ $expense->vendor->name ?? 'N/A' }}</td>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs">{{ $expense->expense_date->format('M d, Y') }}</td>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs font-medium">{{ $expense->title }}</td>
                            <td class="px-6 py-4 text-right text-sm">{{ number_format($expense->amount, 2) }}</td>
                            <td class="px-6 py-4 text-center text-sm">
                                <span class="px-2 inline-flex text-[10px] leading-4 font-semibold rounded-full bg-blue-100 text-blue-800">
                                    {{ ucfirst($expense->status) }}
                                </span>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="text-center py-10 text-gray-500">No vendor payments found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="p-4 border-t">
            {{ $expenses->links() }}
        </div>
    </div>
</div>
@endsection



