@extends('layouts.admin')

@section('title', 'Expense Approval Flow')

@section('content')
<div class="p-6 lg:p-8">
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-800">Expense Approval Flow</h1>
            <p class="text-sm text-gray-600">Review and approve pending expenses.</p>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow-md">
        <div class="p-4 border-b">
            <h3 class="text-lg font-semibold">Pending Expenses</h3>
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Expense #</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Title</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Amount</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Date</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($pendingExpenses as $expense)
                        <tr>
                            <td class="px-6 py-4 text-sm">{{ $expense->expense_number }}</td>
                            <td class="px-6 py-4 text-sm font-medium">{{ $expense->title }}</td>
                            <td class="px-6 py-4 text-sm">Rs. {{ number_format($expense->amount, 2) }}</td>
                            <td class="px-6 py-4 text-sm">{{ $expense->expense_date->format('M d, Y') }}</td>
                            <td class="px-6 py-4 text-sm">
                                <form action="{{ url('finance/expenses.approve', $expense) }}" method="POST" class="inline">
                                    @csrf
                                    <button type="submit" class="text-green-600 hover:text-green-900">Approve</button>
                                </form>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="text-center py-10 text-gray-500">No pending expenses.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="p-4">{{ $pendingExpenses->links() }}</div>
    </div>
</div>
@endsection



