@extends('layouts.admin')

@section('title', 'Branch Level Expenses')

@section('content')
<div class="p-6 lg:p-8" x-data="{ showModal: false }">
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-800">Branch Level Expenses</h1>
            <p class="text-sm text-gray-600">Track expenses at the branch level.</p>
        </div>
        <button @click="showModal = true" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Add Expense</button>
    </div>

    <div class="bg-white rounded-lg shadow-md">
        <div class="p-4 border-b flex justify-between items-center">
            <h3 class="text-lg font-semibold">All Branch Expenses</h3>
            <form method="GET" class="flex items-center space-x-2">
                <input type="date" name="start_date" class="form-input" value="{{ request('start_date') }}">
                <input type="date" name="end_date" class="form-input" value="{{ request('end_date') }}">
                <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Filter</button>
            </form>
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Expense #</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Title</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Category</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Amount</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Date</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Status</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($expenses as $expense)
                        <tr>
                            <td class="px-6 py-4 text-sm">{{ $expense->expense_number }}</td>
                            <td class="px-6 py-4 text-sm font-medium">{{ $expense->title }}</td>
                            <td class="px-6 py-4 text-sm">{{ ucfirst($expense->expense_category) }}</td>
                            <td class="px-6 py-4 text-sm">Rs. {{ number_format($expense->amount, 2) }}</td>
                            <td class="px-6 py-4 text-sm">{{ $expense->expense_date->format('M d, Y') }}</td>
                            <td class="px-6 py-4 text-sm">{{ ucfirst($expense->status) }}</td>
                            <td class="px-6 py-4 text-sm">
                                <a href="{{ route('finance.expenses.edit', $expense) }}" class="text-indigo-600 hover:text-indigo-900 mr-3">Edit</a>
                                <form action="{{ route('finance.expenses.destroy', $expense) }}" method="POST" class="inline" onsubmit="return confirm('Are you sure?')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="text-red-600 hover:text-red-900">Delete</button>
                                </form>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="text-center py-10 text-gray-500">No expenses found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="p-4">{{ $expenses->links() }}</div>
    </div>

    <!-- Add Expense Modal -->
    <div x-show="showModal" @keydown.escape.window="showModal = false" @click.away="showModal = false" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50" x-cloak>
        <div class="relative top-20 mx-auto p-5 border w-full max-w-xl shadow-xl rounded-lg bg-white">
            <div class="flex justify-between items-center mb-4">
                <h3 class="text-lg font-semibold">Add Branch Expense</h3>
                <button @click="showModal = false" class="text-gray-400 hover:text-gray-500">
                    <svg class="h-6 w-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                    </svg>
                </button>
            </div>
            <form action="{{ route('finance.expenses.store') }}" method="POST" enctype="multipart/form-data" novalidate>
                @csrf
                <div class="space-y-4">
                    <div>
                        <label class="block text-xs sm:text-sm font-medium text-gray-700">Title</label>
                        <input type="text" name="title" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                    </div>
                    <div>
                        <label class="block text-xs sm:text-sm font-medium text-gray-700">Amount</label>
                        <input type="number" name="amount" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" step="0.01" required>
                    </div>
                    <div>
                        <label class="block text-xs sm:text-sm font-medium text-gray-700">Date</label>
                        <input type="date" name="expense_date" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                    </div>
                    <div>
                        <label class="block text-xs sm:text-sm font-medium text-gray-700">Category</label>
                        <select name="expense_category" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                            <option value="office_supplies">Office Supplies</option>
                            <option value="utilities">Utilities</option>
                            <option value="rent">Rent</option>
                            <option value="salary">Salary</option>
                            <option value="marketing">Marketing</option>
                            <option value="travel">Travel</option>
                            <option value="maintenance">Maintenance</option>
                            <option value="other">Other</option>
                        </select>
                    </div>
                    <div>
                        <label class="block text-xs sm:text-sm font-medium text-gray-700">Description</label>
                        <textarea name="description" rows="3" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" placeholder="Short description"></textarea>
                    </div>
                    <div>
                        <label class="block text-xs sm:text-sm font-medium text-gray-700">Receipt (optional)</label>
                        <input type="file" name="receipt" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" accept="image/*,.pdf">
                    </div>
                </div>
                <div class="flex justify-end space-x-2 mt-6">
                    <button type="button" @click="showModal = false" class="bg-gray-300 text-gray-700 px-4 py-2 rounded-lg hover:bg-gray-400">Close</button>
                    <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Save Expense</button>
                </div>
            </form>
        </div>
    </div>
</div><!-- End Alpine.js scope -->
@endsection

@push('styles')
<style>
    [x-cloak] { display: none !important; }
</style>
@endpush



