@extends('layouts.admin')

@section('title', 'Edit Expense')

@section('content')
<div class="p-6 lg:p-8">
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-800">Edit Expense</h1>
            <p class="text-sm text-gray-600">Update expense details.</p>
        </div>
        <a href="{{ url()->previous() }}" class="bg-white text-gray-700 px-4 py-2 rounded-lg border shadow-sm hover:bg-gray-50">Back</a>
    </div>

    <div class="bg-white rounded-lg shadow-md p-6">
        <form action="{{ url('finance/expenses.update', $expense) }}" method="POST">
            @csrf
            @method('PUT')
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Title</label>
                    <input type="text" name="title" value="{{ $expense->title }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                </div>
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Amount</label>
                    <input type="number" name="amount" value="{{ $expense->amount }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" step="0.01" required>
                </div>
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Date</label>
                    <input type="date" name="expense_date" value="{{ $expense->expense_date->format('Y-m-d') }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                </div>
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Category</label>
                    <select name="category" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                        <option value="office_supplies" {{ $expense->category == 'office_supplies' ? 'selected' : '' }}>Office Supplies</option>
                        <option value="utilities" {{ $expense->category == 'utilities' ? 'selected' : '' }}>Utilities</option>
                        <option value="rent" {{ $expense->category == 'rent' ? 'selected' : '' }}>Rent</option>
                        <option value="salary" {{ $expense->category == 'salary' ? 'selected' : '' }}>Salary</option>
                        <option value="marketing" {{ $expense->category == 'marketing' ? 'selected' : '' }}>Marketing</option>
                        <option value="travel" {{ $expense->category == 'travel' ? 'selected' : '' }}>Travel</option>
                        <option value="maintenance" {{ $expense->category == 'maintenance' ? 'selected' : '' }}>Maintenance</option>
                        <option value="other" {{ $expense->category == 'other' ? 'selected' : '' }}>Other</option>
                    </select>
                </div>
                <div class="md:col-span-2">
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Description</label>
                    <textarea name="description" rows="3" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">{{ $expense->description }}</textarea>
                </div>
            </div>
            <div class="mt-6">
                <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Update Expense</button>
            </div>
        </form>
    </div>
</div>
@endsection


