@extends('layouts.admin')

@section('title', 'Attendance & Overtime')

@section('content')
<div class="p-6 lg:p-8" x-data="{ showModal: false }" @open-modal.window="showModal = true">
    <!-- Page Header -->
    <div class="max-w-7xl mx-auto flex justify-between items-center mb-6">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-800">Attendance & Overtime</h1>
            <p class="text-sm text-gray-600">Track daily employee attendance and overtime.</p>
        </div>
        <button @click="showModal = true" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Add Attendance</button>
    </div>

    <!-- Filters -->
    <form method="GET" action="{{ route('finance.payroll.attendance') }}" class="max-w-7xl mx-auto bg-white rounded-lg shadow-md p-4 mb-6">
        <div class="grid grid-cols-1 md:grid-cols-5 gap-4">
            <div>
                <label class="block text-[11px] text-gray-600 mb-1">Date</label>
                <input type="date" name="date" value="{{ request('date', date('Y-m-d')) }}" class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
            </div>
            <div>
                <label class="block text-[11px] text-gray-600 mb-1">Employee</label>
                <select name="employee_id" class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                    <option value="">All Employees</option>
                    @foreach($employees as $employee)
                        <option value="{{ $employee->id }}" {{ request('employee_id') == $employee->id ? 'selected' : '' }}>{{ $employee->name }}</option>
                    @endforeach
                </select>
            </div>
            <div>
                <label class="block text-[11px] text-gray-600 mb-1">Status</label>
                <select name="status" class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                    <option value="">All Statuses</option>
                    @foreach(['Present', 'Absent', 'Leave'] as $status)
                        <option value="{{ $status }}" {{ request('status') == $status ? 'selected' : '' }}>{{ $status }}</option>
                    @endforeach
                </select>
            </div>
            <div class="flex items-end">
                <button type="submit" class="w-full bg-gray-900 text-white px-4 py-2 rounded-md hover:bg-black">Filter</button>
            </div>
            <div class="flex items-end">
                <a href="{{ route('finance.payroll.attendance') }}" class="w-full px-4 py-2 rounded-md border border-gray-300 text-gray-700 bg-white hover:bg-gray-50 text-center">Reset</a>
            </div>
        </div>
    </form>

    <!-- Attendance Table -->
    <div class="max-w-7xl mx-auto bg-white rounded-lg shadow-md">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50 sticky top-0 z-10">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Employee</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Date</th>
                        <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase">Status</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Overtime (Hrs)</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($attendances as $attendance)
                        <tr class="odd:bg-white even:bg-gray-50">
                            <td class="px-6 py-3 text-sm">{{ $attendance->employee->name ?? 'N/A' }}</td>
                            <td class="px-6 py-3 text-sm">{{ optional($attendance->date)->format('M d, Y') }}</td>
                            <td class="px-6 py-3 text-center">
                                @php
                                    $statusClasses = [
                                        'Present' => 'bg-green-100 text-green-700',
                                        'Absent' => 'bg-red-100 text-red-700',
                                        'Leave' => 'bg-yellow-100 text-yellow-700',
                                    ];
                                    $cls = $statusClasses[$attendance->status] ?? 'bg-gray-200 text-gray-700';
                                @endphp
                                <span class="px-2 py-1 text-xs rounded-full {{ $cls }}">{{ $attendance->status }}</span>
                            </td>
                            <td class="px-6 py-3 text-right text-sm">{{ number_format($attendance->overtime_hours, 2) }}</td>
                            <td class="px-6 py-3 text-right text-sm"><a href="{{ route('finance.payroll.attendance.edit', $attendance) }}" class="text-indigo-600 hover:text-indigo-800">Edit</a></td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="px-6 py-10">
                                <div class="flex flex-col items-center text-center text-gray-600">
                                    <i class="fas fa-clipboard-list text-3xl mb-2"></i>
                                    <p class="text-sm">No attendance records found.</p>
                                    <button @click="showModal = true" class="mt-4 bg-blue-600 text-white px-3 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700">Add Attendance</button>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="p-4">{{ method_exists($attendances, 'links') ? $attendances->links() : '' }}</div>
    </div>

    <!-- Add Attendance Modal -->
    <div x-show="showModal" @click.away="showModal = false" class="fixed inset-0 bg-gray-600 bg-opacity-50 h-full w-full z-50" x-cloak>
        <div class="relative top-10 mx-auto p-5 border w-full max-w-lg shadow-lg rounded-md bg-white">
            <form action="{{ route('finance.payroll.attendance.store') }}" method="POST">
                @csrf
                <h3 class="text-lg font-semibold mb-4">Add Attendance Record</h3>
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm">Employee</label>
                        <select name="employee_id" class="form-select" required>
                            <option value="">Select Employee</option>
                            @foreach($employees as $employee)
                                <option value="{{ $employee->id }}">{{ $employee->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm">Date</label>
                        <input type="date" name="date" class="form-input" value="{{ date('Y-m-d') }}" required>
                    </div>
                    <div>
                        <label class="block text-sm">Status</label>
                        <select name="status" class="form-select" required>
                            @foreach(['Present', 'Absent', 'Leave'] as $status)
                                <option value="{{ $status }}">{{ $status }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm">Overtime (Hours)</label>
                        <input type="number" name="overtime_hours" class="form-input" step="0.01" value="0">
                    </div>
                    <div>
                        <label class="block text-sm">Remarks</label>
                        <textarea name="remarks" rows="2" class="form-input"></textarea>
                    </div>
                </div>
                <div class="flex justify-end space-x-2 mt-6">
                    <button type="button" @click="showModal = false" class="bg-gray-300 text-gray-700 px-4 py-2 rounded-lg">Close</button>
                    <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Save</button>
                </div>
            </form>
        </div>
    </div>
</div>



