@extends('layouts.admin')

@section('title', 'Edit Attendance')

@section('content')
<div class="p-6 lg:p-8">
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-800">Edit Attendance</h1>
            <p class="text-sm text-gray-600">Update attendance details.</p>
        </div>
        <a href="{{ url('finance/payroll.attendance') }}" class="bg-white text-gray-700 px-4 py-2 rounded-lg border shadow-sm hover:bg-gray-50">Back</a>
    </div>

    <div class="bg-white rounded-lg shadow-md p-6">
        <form action="{{ url('finance/payroll.attendance.update', $attendance) }}" method="POST">
            @csrf
            @method('PUT')
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Employee</label>
                    <select name="employee_id" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                        @foreach($employees as $employee)
                            <option value="{{ $employee->id }}" {{ $attendance->employee_id == $employee->id ? 'selected' : '' }}>{{ $employee->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Date</label>
                    <input type="date" name="date" value="{{ $attendance->date->format('Y-m-d') }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                </div>
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Check-in</label>
                    <input type="time" name="check_in" value="{{ $attendance->check_in }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                </div>
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Check-out</label>
                    <input type="time" name="check_out" value="{{ $attendance->check_out }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                </div>
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Overtime Hours</label>
                    <input type="number" name="overtime_hours" value="{{ $attendance->overtime_hours }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" step="0.01">
                </div>
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Status</label>
                    <select name="status" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                        <option value="Present" {{ $attendance->status == 'Present' ? 'selected' : '' }}>Present</option>
                        <option value="Absent" {{ $attendance->status == 'Absent' ? 'selected' : '' }}>Absent</option>
                        <option value="Leave" {{ $attendance->status == 'Leave' ? 'selected' : '' }}>Leave</option>
                    </select>
                </div>
            </div>
            <div class="flex justify-end mt-6">
                <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Update Attendance</button>
            </div>
        </form>
    </div>
</div>
@endsection


