@extends('layouts.admin')

@section('title', 'Edit Employee')

@section('content')
<div class="p-6 lg:p-8">
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-800">Edit Employee</h1>
            <p class="text-sm text-gray-600">Update employee details.</p>
        </div>
        <a href="{{ route('finance.payroll.employee-master') }}" class="bg-white text-gray-700 px-4 py-2 rounded-lg border shadow-sm hover:bg-gray-50">Back</a>
    </div>

    <div class="bg-white rounded-lg shadow-md p-6">
        <form action="{{ route('finance.payroll.employees.update', $employee) }}" method="POST">
            @csrf
            @method('PUT')
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Full Name</label>
                    <input type="text" name="name" value="{{ $employee->name }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                </div>
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Email Address</label>
                    <input type="email" name="email" value="{{ $employee->email }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                </div>
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Phone Number</label>
                    <input type="text" name="phone" value="{{ $employee->phone }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                </div>
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Department</label>
                    <input type="text" name="department" value="{{ $employee->department }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                </div>
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Designation</label>
                    <input type="text" name="designation" value="{{ $employee->designation }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                </div>
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Joining Date</label>
                    <input type="date" name="date_of_joining" value="{{ $employee->date_of_joining->format('Y-m-d') }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                </div>
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Salary</label>
                    <input type="number" name="salary" value="{{ $employee->salary }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" step="0.01" required>
                </div>
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Employee ID</label>
                    <input type="text" name="employee_id" value="{{ $employee->employee_id }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                </div>
            </div>
            <div class="flex justify-end mt-6">
                <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Update Employee</button>
            </div>
        </form>
    </div>
</div>
@endsection


