@extends('layouts.admin')

@section('title', 'Employee Master Data')

@section('content')
<div class="p-6 lg:p-8" x-data="{ showModal: false }" @open-modal.window="showModal = true">
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-800">Employee Master Data</h1>
            <p class="text-sm text-gray-600">Manage all employee records.</p>
        </div>
        <button @click="showModal = true" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Add Employee</button>
    </div>

    <div class="bg-white rounded-lg shadow-md">
        <div class="p-4 border-b flex justify-between items-center">
            <h3 class="text-lg font-semibold">All Employees</h3>
            <form method="GET" class="flex items-center space-x-2">
                <input type="date" name="start_date" class="form-input" value="{{ request('start_date') }}">
                <input type="date" name="end_date" class="form-input" value="{{ request('end_date') }}">
                <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Filter</button>
            </form>
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Employee ID</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Name</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Department</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Designation</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Joining Date</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Salary</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($employees as $employee)
                        <tr>
                            <td class="px-6 py-4 text-sm">{{ $employee->employee_id }}</td>
                            <td class="px-6 py-4 text-sm font-medium">{{ $employee->name }}</td>
                            <td class="px-6 py-4 text-sm">{{ $employee->department }}</td>
                            <td class="px-6 py-4 text-sm">{{ $employee->designation }}</td>
                            <td class="px-6 py-4 text-sm">{{ optional($employee->date_of_joining)->format('M d, Y') ?? '-' }}</td>
                            <td class="px-6 py-4 text-sm">Rs. {{ number_format($employee->salary, 2) }}</td>
                            <td class="px-6 py-4 text-sm">
                                <a href="{{ route('finance.payroll.employees.edit', $employee) }}" class="text-indigo-600 hover:text-indigo-900">Edit</a>
                                <form action="{{ route('finance.payroll.employees.destroy', $employee) }}" method="POST" class="inline" onsubmit="return confirm('Are you sure?')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="text-red-600 hover:text-red-900 ml-2">Delete</button>
                                </form>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="text-center py-10">No employees found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="p-4">{{ $employees->links() }}</div>
    </div>

    <!-- Add Employee Modal -->
    <div x-show="showModal" @click.away="showModal = false" class="fixed inset-0 bg-gray-600 bg-opacity-50 h-full w-full z-50" x-cloak>
        <div class="relative top-10 mx-auto p-5 border w-full max-w-2xl shadow-lg rounded-md bg-white">
            <h3 class="text-lg font-semibold mb-4">Add New Employee</h3>
            <form action="{{ route('finance.payroll.employees.store') }}" method="POST">
                @csrf
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div><label class="block text-sm">Full Name</label><input type="text" name="name" class="form-input" required></div>
                    <div><label class="block text-sm">Email</label><input type="email" name="email" class="form-input" required></div>
                    <div><label class="block text-sm">Phone</label><input type="text" name="phone" class="form-input"></div>
                    <div><label class="block text-sm">Department</label><input type="text" name="department" class="form-input" required></div>
                    <div><label class="block text-sm">Designation</label><input type="text" name="designation" class="form-input" required></div>
                    <div><label class="block text-sm">Joining Date</label><input type="date" name="date_of_joining" class="form-input" required></div>
                    <div><label class="block text-sm">Salary</label><input type="number" name="salary" class="form-input" step="0.01" required></div>
                    <div><label class="block text-sm">Employee ID</label><input type="text" name="employee_id" class="form-input" required></div>
                </div>
                <div class="flex justify-end space-x-2 mt-6">
                    <button type="button" @click="showModal = false" class="bg-gray-300 text-gray-700 px-4 py-2 rounded-lg hover:bg-gray-400">Close</button>
                    <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Save Employee</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function () {
        @if($errors->any())
            window.dispatchEvent(new CustomEvent('open-modal'));
        @endif
    });
</script>
@endpush



