@extends('layouts.admin')

@section('title', 'Payroll Run')

@section('content')
<div class="p-6 lg:p-8">
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-800">Payroll Run</h1>
            <p class="text-sm text-gray-600">Process payroll for selected month and employees.</p>
        </div>
        <form method="POST" action="{{ route('finance.payroll.payroll-run.process') }}" class="flex items-center space-x-2">
            @csrf
            <input type="month" name="month" value="{{ request('month', date('Y-m')) }}" class="form-input">
            <select name="employee_id" class="form-select">
                <option value="">All Employees</option>
                @foreach($employees as $employee)
                    <option value="{{ $employee->id }}">{{ $employee->name }}</option>
                @endforeach
            </select>
            <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Process Payroll</button>
        </form>
    </div>

    <div class="bg-white rounded-lg shadow-md p-6">
        <div class="text-center py-10">
            <h3 class="text-lg font-semibold">Ready to Process Payroll</h3>
            <p class="text-gray-600 mt-2">Select a month and optionally an employee, then submit to generate salary slips.</p>
        </div>
    </div>
</div>
@endsection


