@extends('layouts.admin')

@section('title', 'Tax Deductions')

@section('content')
<div class="p-6 lg:p-8">
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-800">Tax Deductions</h1>
            <p class="text-sm text-gray-600">Manage employee tax deductions.</p>
        </div>
        <button class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition" @click="showModal = true">Add Deduction</button>
    </div>

    <!-- Filters -->
    <form method="GET" action="{{ route('finance.payroll.tax-deductions') }}" class="bg-white rounded-lg shadow-md p-4 mb-6 grid grid-cols-1 md:grid-cols-3 gap-4">
        <input type="month" name="month" value="{{ request('month', date('Y-m')) }}" class="form-input">
        <select name="employee_id" class="form-select">
            <option value="">All Employees</option>
            @foreach($employees as $employee)
                <option value="{{ $employee->id }}" {{ request('employee_id') == $employee->id ? 'selected' : '' }}>{{ $employee->name }}</option>
            @endforeach
        </select>
        <button type="submit" class="bg-gray-800 text-white px-4 py-2 rounded-md">Filter</button>
    </form>

    <!-- Deductions Table -->
    <div class="bg-white rounded-lg shadow-md">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Employee</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Month</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Amount</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Type</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($deductions as $deduction)
                        <tr>
                            <td class="px-6 py-4">{{ $deduction->employee->name ?? 'N/A' }}</td>
                            <td class="px-6 py-4">{{ \Carbon\Carbon::parse($deduction->month)->format('F Y') }}</td>
                            <td class="px-6 py-4 text-right">{{ number_format($deduction->amount, 2) }}</td>
                            <td class="px-6 py-4">{{ ucfirst($deduction->type ?? 'deduction') }}</td>
                        </tr>
                    @empty
                        <tr><td colspan="4" class="text-center py-10 text-gray-500">No tax deductions found.</td></tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <!-- Add Deduction Modal -->
    <div x-data="{ showModal: false }" x-show="showModal" @click.away="showModal = false" class="fixed inset-0 bg-gray-600 bg-opacity-50 h-full w-full z-50" x-cloak>
        <div class="relative top-10 mx-auto p-5 border w-full max-w-lg shadow-lg rounded-md bg-white">
            <form action="{{ route('finance.payroll.tax-deductions.store') }}" method="POST">
                @csrf
                <h3 class="text-lg font-semibold mb-4">Add Tax Deduction</h3>
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm">Employee</label>
                        <select name="employee_id" class="form-select" required>
                            @foreach($employees as $employee)
                                <option value="{{ $employee->id }}">{{ $employee->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm">Month</label>
                        <input type="month" name="month" value="{{ date('Y-m') }}" class="form-input" required>
                    </div>
                    <div>
                        <label class="block text-sm">Amount</label>
                        <input type="number" step="0.01" name="amount" class="form-input" required>
                    </div>
                    <div>
                        <label class="block text-sm">Type</label>
                        <input type="text" name="type" class="form-input" placeholder="e.g., withholding" />
                    </div>
                    <div>
                        <label class="block text-sm">Description</label>
                        <textarea name="description" class="form-input"></textarea>
                    </div>
                </div>
                <div class="flex justify-end space-x-2 mt-6">
                    <button type="button" @click="showModal = false" class="bg-gray-300 text-gray-700 px-4 py-2 rounded-lg hover:bg-gray-400">Close</button>
                    <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-md">Save Deduction</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection



