@extends('layouts.admin')

@section('title', 'Export Center')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-4 sm:mb-6">
        <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Export Center</h1>
        <p class="text-xs sm:text-sm text-gray-600 mt-1">Export reports and data in multiple formats</p>
    </div>

    <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6">
        <form method="POST" action="{{ url('finance/reports.export.data') }}" class="grid grid-cols-1 md:grid-cols-5 gap-3">
            @csrf
            <div>
                <label class="block text-xs text-gray-600 mb-1">Report Type</label>
                <select name="type" class="border rounded-md px-3 py-2 w-full">
                    <option value="financial">Financial</option>
                    <option value="operational">Operational</option>
                    <option value="custom">Custom</option>
                </select>
            </div>
            <div>
                <label class="block text-xs text-gray-600 mb-1">Format</label>
                <select name="format" class="border rounded-md px-3 py-2 w-full">
                    <option value="csv">CSV</option>
                    <option value="xlsx" disabled>XLSX (coming soon)</option>
                    <option value="pdf" disabled>PDF (coming soon)</option>
                </select>
            </div>
            <div>
                <label class="block text-xs text-gray-600 mb-1">Start Date</label>
                <input type="date" name="start_date" class="border rounded-md px-3 py-2 w-full" />
            </div>
            <div>
                <label class="block text-xs text-gray-600 mb-1">End Date</label>
                <input type="date" name="end_date" class="border rounded-md px-3 py-2 w-full" />
            </div>
            <div class="flex items-end">
                <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Export</button>
            </div>
        </form>
    </div>
    <div class="mt-4 text-xs text-gray-500">Note: CSV export is available; XLSX/PDF coming soon.</div>
</div>
@endsection


