@extends('layouts.admin')

@section('title', 'Scheduled Reports')

@section('content')
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-4 sm:mb-6">
        <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Scheduled Reports</h1>
        <p class="text-xs sm:text-sm text-gray-600 mt-1">Create and manage automated report schedules</p>
    </div>

    @if (session('status'))
        <div class="mb-4 p-3 rounded bg-green-50 border border-green-200 text-green-800">
            {{ session('status') }}
        </div>
    @endif

    <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6 mb-6">
        <h2 class="text-lg font-semibold text-gray-800 mb-4">Create New Schedule</h2>
        <form method="POST" action="{{ url('finance/reports.schedule.store') }}" class="space-y-4">
            @csrf
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label for="name" class="block text-xs sm:text-sm font-medium text-gray-700">Schedule Name</label>
                    <input type="text" id="name" name="name" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500" placeholder="e.g., Weekly Financial Summary">
                </div>
                <div>
                    <label for="type" class="block text-xs sm:text-sm font-medium text-gray-700">Report Type</label>
                    <select id="type" name="type" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                        <option value="financial">Financial</option>
                        <option value="operational">Operational</option>
                        <option value="custom">Custom</option>
                    </select>
                </div>
                <div>
                    <label for="format" class="block text-xs sm:text-sm font-medium text-gray-700">Format</label>
                    <select id="format" name="format" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                        <option value="csv">CSV</option>
                        <option value="xlsx">Excel (XLSX)</option>
                        <option value="pdf">PDF</option>
                    </select>
                </div>
                <div>
                    <label for="frequency" class="block text-xs sm:text-sm font-medium text-gray-700">Frequency</label>
                    <select id="frequency" name="frequency" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                        <option value="daily">Daily</option>
                        <option value="weekly">Weekly</option>
                        <option value="monthly">Monthly</option>
                    </select>
                </div>
            </div>
            <div>
                <label for="recipients" class="block text-xs sm:text-sm font-medium text-gray-700">Recipients (comma-separated emails)</label>
                <input type="text" id="recipients" name="recipients" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500" placeholder="finance@example.com, ops@example.com">
            </div>
            <div>
                <label for="filters" class="block text-xs sm:text-sm font-medium text-gray-700">Filters (optional JSON)</label>
                <textarea id="filters" name="filters" rows="3" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500" placeholder='{"start_date":"2025-10-01","end_date":"2025-10-31"}'></textarea>
            </div>
            <div class="flex items-center">
                <input type="checkbox" id="is_active" name="is_active" value="1" checked class="h-4 w-4 text-blue-600 border-gray-300 rounded">
                <label for="is_active" class="ml-2 text-sm text-gray-700">Active</label>
            </div>
            <div>
                <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Create Schedule</button>
            </div>
        </form>
    </div>

    <div class="bg-white rounded-lg border border-gray-200">
        <div class="px-6 py-4 border-b border-gray-200">
            <h2 class="text-lg font-semibold text-gray-800">Existing Schedules</h2>
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Name</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Type</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Format</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Frequency</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Recipients</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Next Run</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Active</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Created</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse ($schedules as $schedule)
                        <tr>
                            <td class="px-6 py-4 text-sm text-gray-900">{{ $schedule->name }}</td>
                            <td class="px-6 py-4 text-sm text-gray-700">{{ ucfirst($schedule->type) }}</td>
                            <td class="px-6 py-4 text-sm text-gray-700">{{ strtoupper($schedule->format) }}</td>
                            <td class="px-6 py-4 text-sm text-gray-700">{{ ucfirst($schedule->frequency) }}</td>
                            <td class="px-6 py-4 text-sm text-gray-700 truncate max-w-xs" title="{{ $schedule->recipients }}">{{ $schedule->recipients ?: '—' }}</td>
                            <td class="px-6 py-4 text-sm text-gray-700">{{ optional($schedule->next_run_at)->format('Y-m-d H:i') ?? '—' }}</td>
                            <td class="px-6 py-4 text-sm">
                                @if($schedule->is_active)
                                    <span class="inline-flex items-center px-2 py-1 rounded text-xs font-semibold bg-green-100 text-green-800">Active</span>
                                @else
                                    <span class="inline-flex items-center px-2 py-1 rounded text-xs font-semibold bg-gray-100 text-gray-800">Inactive</span>
                                @endif
                            </td>
                            <td class="px-6 py-4 text-sm text-gray-700">{{ $schedule->created_at->format('Y-m-d') }}</td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="8" class="px-6 py-4 text-center text-gray-500">No schedules found</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="px-6 py-4 border-t border-gray-200">
            {{ $schedules->links() }}
        </div>
    </div>
</div>
@endsection




