@extends('layouts.admin')

@section('title', 'Create Deduction')

@section('content')
<div class="p-6 lg:p-8">
    <!-- Page Header -->
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-800">Create New Deduction</h1>
            <p class="text-sm text-gray-600">Apply a deduction to a merchant's account.</p>
        </div>
        <div>
<a href="{{ route('finance.settlements.deductions.index') }}" class="bg-white text-gray-700 px-4 py-2 rounded-lg border shadow-sm hover:bg-gray-50">Back to Deductions</a>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow-md p-6">
<form action="{{ route('finance.settlements.deductions.store') }}" method="POST">
            @csrf
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Merchant -->
                <div>
                    <label for="merchant_id" class="block text-xs sm:text-sm font-medium text-gray-700">Merchant</label>
                    <select name="merchant_id" id="merchant_id" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                        <option value="">Select a merchant</option>
                        @foreach($merchants as $merchant)
                            <option value="{{ $merchant->id }}">{{ $merchant->name }}</option>
                        @endforeach
                    </select>
                </div>

                <!-- Deduction Type -->
                <div>
                    <label for="deduction_type" class="block text-xs sm:text-sm font-medium text-gray-700">Deduction Type</label>
                    <select name="deduction_type" id="deduction_type" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                        <option value="penalty">Penalty</option>
                        <option value="return_charge">Return Charge</option>
                        <option value="damage_claim">Damage Claim</option>
                        <option value="other">Other</option>
                    </select>
                </div>

                <!-- Amount -->
                <div>
                    <label for="amount" class="block text-xs sm:text-sm font-medium text-gray-700">Amount (Rs.)</label>
                    <input type="number" name="amount" id="amount" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" step="0.01" required>
                </div>

                <!-- Deduction Date -->
                <div>
                    <label for="deduction_date" class="block text-xs sm:text-sm font-medium text-gray-700">Deduction Date</label>
                    <input type="date" name="deduction_date" id="deduction_date" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" value="{{ date('Y-m-d') }}" required>
                </div>

                <!-- Description -->
                <div class="md:col-span-2">
                    <label for="description" class="block text-xs sm:text-sm font-medium text-gray-700">Description</label>
                    <textarea name="description" id="description" rows="4" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm"></textarea>
                </div>
            </div>

            <div class="mt-6">
                <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Save Deduction</button>
            </div>
        </form>
    </div>
</div>
@endsection


