@extends('layouts.admin')

@section('title', 'Deduction Details')

@section('content')
<div class="container mx-auto px-4 py-6">
<a href="{{ route('finance.settlements.deductions.index') }}" class="text-blue-600">← Back to Deductions</a>

    <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6 mt-4">
        <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900 mb-4 sm:mb-6">Deduction #{{ $deduction->deduction_number }}</h1>
        <div class="grid grid-cols-1 sm:grid-cols-2 gap-3 sm:gap-4 text-sm">
            <div>
                <p class="text-gray-500">Merchant</p>
                <p class="text-gray-900">{{ $deduction->merchant->name ?? '-' }} ({{ $deduction->merchant->company_name ?? '' }})</p>
            </div>
            <div>
                <p class="text-gray-500">Type</p>
                <p class="text-gray-900">{{ ucfirst(str_replace('_', ' ', $deduction->deduction_type)) }}</p>
            </div>
            <div>
                <p class="text-gray-500">Amount</p>
                <p class="text-gray-900">Rs. {{ number_format($deduction->amount, 2) }}</p>
            </div>
            <div>
                <p class="text-gray-500">Date</p>
                <p class="text-gray-900">{{ optional($deduction->deduction_date)->format('Y-m-d') }}</p>
            </div>
            <div>
                <p class="text-gray-500">Status</p>
                <p>
                    <span class="px-2 inline-flex text-[10px] leading-4 font-semibold rounded-full {{ $deduction->status === 'approved' ? 'bg-green-100 text-green-800' : ($deduction->status === 'pending' ? 'bg-yellow-100 text-yellow-800' : ($deduction->status === 'rejected' ? 'bg-red-100 text-red-800' : 'bg-blue-100 text-blue-800')) }}">
                        {{ ucfirst($deduction->status) }}
                    </span>
                </p>
            </div>
            <div class="sm:col-span-2">
                <p class="text-gray-500">Description</p>
                <p class="text-gray-900">{{ $deduction->description ?? '-' }}</p>
            </div>
        </div>

        <div class="mt-6 flex gap-2 sm:gap-3">
            <a href="{{ route('finance.settlements.deductions.edit', $deduction) }}" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Edit</a>
            <form method="POST" action="{{ route('finance.settlements.deductions.destroy', $deduction) }}" onsubmit="return confirm('Delete this deduction?')">
                @csrf
                @method('DELETE')
                <button type="submit" class="bg-red-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-red-700 transition">Delete</button>
            </form>
        </div>
    </div>
</div>
@endsection


