@extends('layouts.admin')

@section('title', 'Create Dispute')

@section('content')
<div class="p-6 lg:p-8">
    <!-- Page Header -->
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-800">Raise a New Dispute</h1>
            <p class="text-sm text-gray-600">Document a new dispute for a merchant.</p>
        </div>
        <div>
<a href="{{ route('finance.settlements.disputes.index') }}" class="bg-white text-gray-700 px-4 py-2 rounded-lg border shadow-sm hover:bg-gray-50">Back to Disputes</a>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow-md p-6">
<form action="{{ route('finance.settlements.disputes.store') }}" method="POST">
            @csrf
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Merchant -->
                <div>
                    <label for="merchant_id" class="block text-xs sm:text-sm font-medium text-gray-700">Merchant</label>
                    <select name="merchant_id" id="merchant_id" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                        <option value="">Select a merchant</option>
                        @foreach($merchants as $merchant)
                            <option value="{{ $merchant->id }}">{{ $merchant->name }}</option>
                        @endforeach
                    </select>
                </div>

                <!-- Dispute Type -->
                <div>
                    <label for="dispute_type" class="block text-xs sm:text-sm font-medium text-gray-700">Dispute Type</label>
                    <select name="dispute_type" id="dispute_type" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                        <option value="billing_error">Billing Error</option>
                        <option value="service_issue">Service Issue</option>
                        <option value="late_payment">Late Payment</option>
                        <option value="other">Other</option>
                    </select>
                </div>

                <!-- Disputed Amount -->
                <div>
                    <label for="disputed_amount" class="block text-xs sm:text-sm font-medium text-gray-700">Disputed Amount (Rs.)</label>
                    <input type="number" name="disputed_amount" id="disputed_amount" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" step="0.01">
                </div>

                <!-- Priority -->
                <div>
                    <label for="priority" class="block text-xs sm:text-sm font-medium text-gray-700">Priority</label>
                    <select name="priority" id="priority" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                        <option value="low">Low</option>
                        <option value="medium">Medium</option>
                        <option value="high">High</option>
                        <option value="urgent">Urgent</option>
                    </select>
                </div>

                <!-- Subject -->
                <div class="md:col-span-2">
                    <label for="subject" class="block text-xs sm:text-sm font-medium text-gray-700">Subject</label>
                    <input type="text" name="subject" id="subject" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                </div>

                <!-- Description -->
                <div class="md:col-span-2">
                    <label for="description" class="block text-xs sm:text-sm font-medium text-gray-700">Description</label>
                    <textarea name="description" id="description" rows="4" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm"></textarea>
                </div>
            </div>

            <div class="mt-6">
                <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Raise Dispute</button>
            </div>
        </form>
    </div>
</div>
@endsection


