@extends('layouts.admin')

@section('title', 'Edit Dispute')

@section('content')
<div class="container mx-auto px-4 py-6">
    <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900 mb-4 sm:mb-6">Edit Dispute</h1>

    <form method="POST" action="{{ route('finance.settlements.disputes.update', $dispute) }}" class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6 space-y-4">
        @csrf
        @method('PUT')

        <div class="grid grid-cols-1 sm:grid-cols-2 gap-3 sm:gap-4">
            <div>
                <label class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">Merchant</label>
                <select name="merchant_id" class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                    @foreach(($merchants ?? []) as $merchant)
                        <option value="{{ $merchant->id }}" {{ $dispute->merchant_id == $merchant->id ? 'selected' : '' }}>
                            {{ $merchant->name }} ({{ $merchant->company_name }})
                        </option>
                    @endforeach
                </select>
            </div>
            <div>
                <label class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">Type</label>
                <select name="dispute_type" class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                    @foreach(['invoice_amount','payment_delay','deduction_query','service_issue','billing_error','other'] as $type)
                        <option value="{{ $type }}" {{ $dispute->dispute_type === $type ? 'selected' : '' }}>{{ ucwords(str_replace('_',' ', $type)) }}</option>
                    @endforeach
                </select>
            </div>
        </div>

        <div class="grid grid-cols-1 sm:grid-cols-2 gap-3 sm:gap-4">
            <div>
                <label class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">Priority</label>
                <select name="priority" class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                    @foreach(['low','medium','high','urgent'] as $p)
                        <option value="{{ $p }}" {{ $dispute->priority === $p ? 'selected' : '' }}>{{ ucfirst($p) }}</option>
                    @endforeach
                </select>
            </div>
            <div>
                <label class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">Status</label>
                <select name="status" class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                    @foreach(['open','in_review','resolved','closed','escalated'] as $st)
                        <option value="{{ $st }}" {{ $dispute->status === $st ? 'selected' : '' }}>{{ ucwords(str_replace('_',' ', $st)) }}</option>
                    @endforeach
                </select>
            </div>
        </div>

        <div class="grid grid-cols-1 sm:grid-cols-3 gap-4">
            <div>
                <label class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">Invoice</label>
                <select name="invoice_id" class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <option value="">—</option>
                    @foreach(($invoices ?? []) as $inv)
                        <option value="{{ $inv->id }}" {{ $dispute->invoice_id == $inv->id ? 'selected' : '' }}>INV-{{ $inv->id }}</option>
                    @endforeach
                </select>
            </div>
            <div>
                <label class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">Payment</label>
                <select name="payment_id" class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <option value="">—</option>
                    @foreach(($payments ?? []) as $pay)
                        <option value="{{ $pay->id }}" {{ $dispute->payment_id == $pay->id ? 'selected' : '' }}>PAY-{{ $pay->id }}</option>
                    @endforeach
                </select>
            </div>
            <div>
                <label class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">Deduction</label>
                <select name="deduction_id" class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <option value="">—</option>
                    @foreach(($deductions ?? []) as $ded)
                        <option value="{{ $ded->id }}" {{ $dispute->deduction_id == $ded->id ? 'selected' : '' }}>DED-{{ $ded->id }}</option>
                    @endforeach
                </select>
            </div>
        </div>

        <div>
            <label class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">Subject</label>
            <input type="text" name="subject" value="{{ old('subject', $dispute->subject) }}" class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500" required>
        </div>

        <div>
            <label class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">Description</label>
            <textarea name="description" rows="5" class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500" required>{{ old('description', $dispute->description) }}</textarea>
        </div>

        <div>
            <label class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">Resolution</label>
            <textarea name="resolution" rows="3" class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500">{{ old('resolution', $dispute->resolution) }}</textarea>
        </div>

        <div class="flex items-center justify-end gap-2 sm:gap-3">
<a href="{{ route('finance.settlements.disputes.index') }}" class="px-3 sm:px-4 py-2 border border-gray-300 rounded-md text-xs sm:text-sm font-semibold text-gray-700 hover:bg-gray-50 transition">Cancel</a>
            <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Update</button>
        </div>
    </form>
</div>
@endsection


