@extends('layouts.admin')

@section('title', 'Dispute Details')

@section('content')
<div class="container mx-auto px-4 py-6">
<a href="{{ route('finance.settlements.disputes.index') }}" class="text-blue-600">← Back to Disputes</a>

    <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6 mt-4">
        <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900 mb-4 sm:mb-6">Dispute #{{ $dispute->id }}</h1>
        <div class="grid grid-cols-1 sm:grid-cols-2 gap-3 sm:gap-4 text-sm">
            <div>
                <p class="text-gray-500">Merchant</p>
                <p class="text-gray-900">{{ $dispute->merchant->name ?? '-' }} ({{ $dispute->merchant->company_name ?? '' }})</p>
            </div>
            <div>
                <p class="text-gray-500">Type</p>
                <p class="text-gray-900">{{ ucwords(str_replace('_',' ', $dispute->dispute_type)) }}</p>
            </div>
            <div>
                <p class="text-gray-500">Priority</p>
                <p class="text-gray-900">{{ ucfirst($dispute->priority) }}</p>
            </div>
            <div>
                <p class="text-gray-500">Status</p>
                <p>
                    <span class="px-2 inline-flex text-[10px] leading-4 font-semibold rounded-full bg-gray-100 text-gray-800">{{ ucwords(str_replace('_',' ', $dispute->status)) }}</span>
                </p>
            </div>
            <div class="sm:col-span-2">
                <p class="text-gray-500">Description</p>
                <p class="text-gray-900">{{ $dispute->description ?? '-' }}</p>
            </div>
            @if($dispute->resolution)
            <div class="sm:col-span-2">
                <p class="text-gray-500">Resolution</p>
                <p class="text-gray-900">{{ $dispute->resolution }}</p>
            </div>
            @endif
        </div>

        <div class="mt-6 flex gap-2 sm:gap-3">
            <a href="{{ route('finance.settlements.disputes.edit', $dispute) }}" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Edit</a>
            <form method="POST" action="{{ route('finance.settlements.disputes.destroy', $dispute) }}" onsubmit="return confirm('Delete this dispute?')">
                @csrf
                @method('DELETE')
                <button type="submit" class="bg-red-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-red-700 transition">Delete</button>
            </form>
        </div>
    </div>
</div>
@endsection


