@extends('layouts.admin')

@section('title', 'Create Invoice')

@push('styles')
<style>
    body {
        background: #f8f9fa;
        font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
    }
    
    .invoice-container {
        max-width: 1400px;
        margin: 0 auto;
        padding: 20px;
    }
    
    .invoice-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 30px;
    }
    
    .invoice-title {
        font-size: 16px;
        font-weight: 600;
        color: #1a1a1a;
    }
    
    .btn-embed {
        background: white;
        border: 1px solid #e5e7eb;
        padding: 8px 20px;
        border-radius: 6px;
        font-size: 14px;
        color: #6b7280;
        cursor: pointer;
        transition: all 0.2s;
    }
    
    .btn-embed:hover {
        border-color: #d1d5db;
        background: #f9fafb;
    }
    
    .main-content {
        display: grid;
        grid-template-columns: 1fr 320px;
        gap: 30px;
    }
    
    .left-section {
        background: white;
        border-radius: 12px;
        padding: 30px;
        border: 1px solid #e5e7eb;
    }
    
    .right-section {
        background: white;
        border-radius: 12px;
        padding: 25px;
        border: 1px solid #e5e7eb;
        height: fit-content;
        position: sticky;
        top: 20px;
    }
    
    .section-title {
        font-size: 15px;
        font-weight: 600;
        color: #1a1a1a;
        margin-bottom: 20px;
    }
    
    .form-group {
        margin-bottom: 20px;
    }
    
    .form-label {
        font-size: 13px;
        color: #6b7280;
        margin-bottom: 8px;
        display: block;
        font-weight: 500;
    }
    
    .form-control, .form-select {
        width: 100%;
        padding: 10px 12px;
        border: 1px solid #e5e7eb;
        border-radius: 6px;
        font-size: 14px;
        background: white;
        transition: all 0.2s;
    }
    
    .form-control:focus, .form-select:focus {
        outline: none;
        border-color: #3b82f6;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
    }
    
    .invoice-grid {
        display: grid;
        grid-template-columns: repeat(3, 1fr);
        gap: 15px;
        margin-bottom: 30px;
    }
    
    .task-table {
        width: 100%;
        border-collapse: separate;
        border-spacing: 0;
        margin-top: 10px;
    }
    
    .task-table thead th {
        background: #f9fafb;
        padding: 12px 16px;
        text-align: left;
        font-size: 12px;
        font-weight: 600;
        color: #6b7280;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        border-bottom: 1px solid #e5e7eb;
    }
    
    .task-table thead th:first-child {
        border-radius: 6px 0 0 0;
    }
    
    .task-table thead th:last-child {
        border-radius: 0 6px 0 0;
    }
    
    .task-table tbody td {
        padding: 16px;
        border-bottom: 1px solid #f3f4f6;
    }
    
    .task-table tbody tr:hover {
        background: #f9fafb;
    }
    
    .task-input {
        border: none;
        background: transparent;
        padding: 8px 12px;
        width: 100%;
        font-size: 14px;
        color: #1a1a1a;
    }
    
    .task-input:focus {
        outline: none;
        background: white;
        border: 1px solid #3b82f6;
        border-radius: 4px;
    }
    
    .task-input-small {
        width: 80px;
        text-align: center;
    }
    
    .icon-btn {
        background: none;
        border: none;
        cursor: pointer;
        padding: 6px;
        color: #9ca3af;
        transition: color 0.2s;
    }
    
    .icon-btn:hover {
        color: #3b82f6;
    }
    
    .icon-btn-danger:hover {
        color: #ef4444;
    }
    
    .btn-add-task {
        background: transparent;
        border: 1px dashed #d1d5db;
        padding: 12px 24px;
        border-radius: 6px;
        font-size: 14px;
        color: #6b7280;
        cursor: pointer;
        width: 100%;
        margin-top: 16px;
        transition: all 0.2s;
    }
    
    .btn-add-task:hover {
        border-color: #3b82f6;
        color: #3b82f6;
        background: #f0f9ff;
    }
    
    .summary-section {
        margin-top: 20px;
        padding-top: 20px;
        border-top: 1px solid #e5e7eb;
    }
    
    .summary-row {
        display: flex;
        justify-content: space-between;
        padding: 10px 0;
        font-size: 14px;
        color: #4b5563;
    }
    
    .summary-row.total {
        font-weight: 600;
        font-size: 16px;
        color: #1a1a1a;
        padding-top: 15px;
        margin-top: 10px;
        border-top: 2px solid #e5e7eb;
    }
    
    .invoice-number {
        font-size: 14px;
        font-weight: 600;
        color: #1a1a1a;
        margin-bottom: 20px;
    }
    
    .bill-to {
        margin-bottom: 20px;
    }
    
    .bill-to-label {
        font-size: 12px;
        color: #9ca3af;
        margin-bottom: 8px;
        font-weight: 500;
    }
    
    .bill-to-content {
        font-size: 14px;
        color: #1a1a1a;
        line-height: 1.6;
    }
    
    .bill-to-name {
        font-weight: 600;
        margin-bottom: 4px;
    }
    
    .bill-to-address {
        font-size: 13px;
        color: #6b7280;
    }
    
    .item-badge {
        display: inline-block;
        padding: 4px 12px;
        background: #f3f4f6;
        border-radius: 4px;
        font-size: 13px;
        color: #4b5563;
        margin: 4px 4px 4px 0;
    }
    
    .btn-create {
        background: #3b82f6;
        color: white;
        border: none;
        padding: 12px 24px;
        border-radius: 6px;
        font-size: 14px;
        font-weight: 600;
        cursor: pointer;
        width: 100%;
        margin-top: 20px;
        transition: all 0.2s;
    }
    
    .btn-create:hover {
        background: #2563eb;
        transform: translateY(-1px);
        box-shadow: 0 4px 12px rgba(59, 130, 246, 0.3);
    }
    
    .text-muted {
        color: #9ca3af;
        font-size: 13px;
    }
</style>
@endpush

@section('content')
<div class="invoice-container">
    <!-- Header -->
    <div class="invoice-header">
        <div class="invoice-title">
<i class="fas fa-arrow-left" style="margin-right: 12px; cursor: pointer;" onclick="window.location='{{ route('admin.finance.settlements.invoices.index') }}'"></i>
            Create Invoice
        </div>
        <button class="btn-embed">
            <i class="fas fa-link" style="margin-right: 8px;"></i> Embed
        </button>
    </div>

<form action="{{ route('admin.finance.settlements.invoices.store') }}" method="POST" id="invoiceForm">
        @csrf
        
        <div class="main-content">
            <!-- Left Section -->
            <div class="left-section">
                <!-- Invoice Details -->
                <div class="section-title">Invoice Details</div>
                
                <div class="invoice-grid">
                    <div class="form-group">
                        <label class="form-label">Invoice #</label>
                        <input type="text" class="form-control" value="Auto Generated" disabled>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label">Date Issued</label>
                        <input type="date" name="invoice_date" class="form-control" value="{{ date('Y-m-d') }}" required>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label">Due Date</label>
                        <input type="date" name="due_date" class="form-control" required>
                    </div>
                </div>

                <!-- Bill/Payment -->
                <div class="section-title" style="margin-top: 30px;">Bill/Payment</div>
                
                <div class="form-group">
                    <label class="form-label">Client Name</label>
                    <select name="merchant_id" id="merchant_id" class="form-select" required>
                        <option value="">Select Merchant</option>
                        @foreach($merchants as $merchant)
                            <option value="{{ $merchant->id }}" data-name="{{ $merchant->name }}" data-email="{{ $merchant->email }}" data-company="{{ $merchant->company_name }}">
                                {{ $merchant->name }} - {{ $merchant->email }}
                            </option>
                        @endforeach
                    </select>
                </div>
                
                <div class="form-group">
                    <label class="form-label">Payment Method</label>
                    <select class="form-select">
                        <option>Viziy And Dividea</option>
                        <option>Bank Transfer</option>
                        <option>Cash</option>
                        <option>Cheque</option>
                    </select>
                </div>

                <!-- List Task -->
                <div class="section-title" style="margin-top: 30px;">List Task</div>
                
                <table class="task-table" id="taskTable">
                    <thead>
                        <tr>
                            <th>Task Name</th>
                            <th style="width: 100px;">Hours</th>
                            <th style="width: 100px;">Rate</th>
                            <th style="width: 80px;"></th>
                        </tr>
                    </thead>
                    <tbody id="taskRows">
                        <tr>
                            <td>
                                <input type="text" name="items[0][description]" class="task-input" placeholder="Enter task name" required>
                            </td>
                            <td>
                                <input type="number" name="items[0][quantity]" class="task-input task-input-small item-quantity" value="1" min="1" required>
                            </td>
                            <td>
                                <input type="number" name="items[0][unit_price]" class="task-input task-input-small item-rate" value="0" step="0.01" min="0" required>
                            </td>
                            <td style="text-align: center;">
                                <button type="button" class="icon-btn icon-btn-danger remove-task" disabled>
                                    <i class="fas fa-trash"></i>
                                </button>
                            </td>
                        </tr>
                    </tbody>
                </table>
                
                <button type="button" class="btn-add-task" id="addTaskBtn">
                    <i class="fas fa-plus" style="margin-right: 8px;"></i> Add New Task
                </button>
                
                <input type="hidden" name="subtotal" id="subtotal" value="0">
                <input type="hidden" name="tax_amount" value="0">
                <input type="hidden" name="discount_amount" value="0">
            </div>

            <!-- Right Section -->
            <div class="right-section">
                <div class="invoice-number">Invoice<br>C-<span id="invoicePreview">#AUTO-GEN</span></div>
                
                <div class="bill-to">
                    <div class="bill-to-label">Bill to</div>
                    <div class="bill-to-content">
                        <div class="bill-to-name" id="clientName">Marrie Ferdo</div>
                        <div class="bill-to-address" id="clientAddress">
                            6, Rancherie Verdure, Flacurrs,<br>
                            French Fleur 413134
                        </div>
                    </div>
                </div>
                
                <div class="bill-to">
                    <div class="bill-to-label">Item Type</div>
                    <div id="itemTypes">
                        <span class="item-badge">Logo Design</span>
                        <span class="item-badge">No design credits</span>
                    </div>
                </div>
                
                <div class="summary-section">
                    <div class="summary-row">
                        <span>Subtotal</span>
                        <span id="displaySubtotal">Rs. 0.00</span>
                    </div>
                    <div class="summary-row total">
                        <span>Total</span>
                        <span id="displayTotal">Rs. 0.00</span>
                    </div>
                </div>
                
                <button type="submit" class="btn-create">
                    <i class="fas fa-check" style="margin-right: 8px;"></i> Create Invoice
                </button>
            </div>
        </div>
    </form>
</div>

@push('scripts')
<script>
let taskIndex = 1;

// Add new task row
document.getElementById('addTaskBtn').addEventListener('click', function() {
    const tbody = document.getElementById('taskRows');
    const newRow = document.createElement('tr');
    newRow.innerHTML = `
        <td>
            <input type="text" name="items[${taskIndex}][description]" class="task-input" placeholder="Enter task name" required>
        </td>
        <td>
            <input type="number" name="items[${taskIndex}][quantity]" class="task-input task-input-small item-quantity" value="1" min="1" required>
        </td>
        <td>
            <input type="number" name="items[${taskIndex}][unit_price]" class="task-input task-input-small item-rate" value="0" step="0.01" min="0" required>
        </td>
        <td style="text-align: center;">
            <button type="button" class="icon-btn icon-btn-danger remove-task">
                <i class="fas fa-trash"></i>
            </button>
        </td>
    `;
    tbody.appendChild(newRow);
    taskIndex++;
    updateRemoveButtons();
});

// Remove task
document.getElementById('taskRows').addEventListener('click', function(e) {
    if (e.target.closest('.remove-task')) {
        e.target.closest('tr').remove();
        updateRemoveButtons();
        calculateTotal();
    }
});

// Calculate total
document.getElementById('taskRows').addEventListener('input', function(e) {
    if (e.target.classList.contains('item-quantity') || e.target.classList.contains('item-rate')) {
        calculateTotal();
    }
});

function calculateTotal() {
    let subtotal = 0;
    document.querySelectorAll('#taskRows tr').forEach(function(row) {
        const quantity = parseFloat(row.querySelector('.item-quantity').value) || 0;
        const rate = parseFloat(row.querySelector('.item-rate').value) || 0;
        subtotal += quantity * rate;
    });
    
    const formatCurrency = (num) => 'Rs. ' + num.toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    
    document.getElementById('subtotal').value = subtotal.toFixed(2);
    document.getElementById('displaySubtotal').textContent = formatCurrency(subtotal);
    document.getElementById('displayTotal').textContent = formatCurrency(subtotal);
}

function updateRemoveButtons() {
    const rows = document.querySelectorAll('#taskRows tr');
    rows.forEach((row, index) => {
        const removeBtn = row.querySelector('.remove-task');
        removeBtn.disabled = rows.length === 1;
        removeBtn.style.opacity = rows.length === 1 ? '0.3' : '1';
        removeBtn.style.cursor = rows.length === 1 ? 'not-allowed' : 'pointer';
    });
}

// Update client info on merchant selection
document.getElementById('merchant_id').addEventListener('change', function() {
    const selected = this.options[this.selectedIndex];
    if (selected.value) {
        const name = selected.dataset.name || selected.text.split(' - ')[0];
        const email = selected.dataset.email || '';
        const company = selected.dataset.company || '';
        
        document.getElementById('clientName').textContent = name;
        document.getElementById('clientAddress').innerHTML = company + '<br>' + email;
    }
});

// Initial calculation
calculateTotal();
updateRemoveButtons();
</script>
@endpush
@endsection
