@extends('layouts.admin')

@section('title', 'Invoice Details')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0">Invoice #{{ $invoice->invoice_number }}</h1>
        <div class="btn-group">
<a href="{{ route('finance.settlements.invoices.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back
            </a>
            <a href="{{ route('finance.settlements.invoices.edit', $invoice) }}" class="btn btn-primary">
                <i class="fas fa-edit"></i> Edit
            </a>
        </div>
    </div>

    <div class="row">
        <div class="col-md-8">
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">Invoice Details</h5>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <strong>Merchant:</strong><br>
                            {{ $invoice->merchant->name }}
                        </div>
                        <div class="col-md-6">
                            <strong>Invoice Number:</strong><br>
                            {{ $invoice->invoice_number }}
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <strong>Invoice Date:</strong><br>
                            {{ $invoice->invoice_date->format('M d, Y') }}
                        </div>
                        <div class="col-md-6">
                            <strong>Due Date:</strong><br>
                            {{ $invoice->due_date->format('M d, Y') }}
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-md-12">
                            <strong>Status:</strong><br>
                            <span class="badge bg-{{ $invoice->status == 'paid' ? 'success' : ($invoice->status == 'sent' ? 'info' : 'secondary') }}">
                                {{ ucfirst($invoice->status) }}
                            </span>
                        </div>
                    </div>

                    <hr>

                    <h6 class="mb-3">Invoice Items</h6>
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Description</th>
                                <th class="text-end">Quantity</th>
                                <th class="text-end">Unit Price</th>
                                <th class="text-end">Total</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($invoice->items as $item)
                            <tr>
                                <td>{{ $item->description }}</td>
                                <td class="text-end">{{ $item->quantity }}</td>
                                <td class="text-end">Rs. {{ number_format($item->unit_price, 2) }}</td>
                                <td class="text-end">Rs. {{ number_format($item->total_price, 2) }}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>

                    @if($invoice->notes)
                    <div class="mt-3">
                        <strong>Notes:</strong><br>
                        <p>{{ $invoice->notes }}</p>
                    </div>
                    @endif
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">Summary</h5>
                </div>
                <div class="card-body">
                    <div class="d-flex justify-content-between mb-2">
                        <span>Subtotal:</span>
                        <strong>Rs. {{ number_format($invoice->subtotal, 2) }}</strong>
                    </div>
                    <div class="d-flex justify-content-between mb-2">
                        <span>Tax:</span>
                        <strong>Rs. {{ number_format($invoice->tax_amount, 2) }}</strong>
                    </div>
                    <div class="d-flex justify-content-between mb-2">
                        <span>Discount:</span>
                        <strong>Rs. {{ number_format($invoice->discount_amount, 2) }}</strong>
                    </div>
                    <hr>
                    <div class="d-flex justify-content-between">
                        <strong>Total:</strong>
                        <strong class="fs-4 text-primary">Rs. {{ number_format($invoice->total_amount, 2) }}</strong>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Actions</h5>
                </div>
                <div class="card-body">
                    @if($invoice->status == 'draft')
<form action="{{ route('finance.settlements.invoices.send', $invoice) }}" method="POST" class="mb-2">
                        @csrf
                        <button type="submit" class="btn btn-primary w-100">
                            <i class="fas fa-paper-plane"></i> Send Invoice
                        </button>
                    </form>
                    @endif

                    @if($invoice->status != 'paid')
<form action="{{ route('finance.settlements.invoices.mark-paid', $invoice) }}" method="POST" class="mb-2">
                        @csrf
                        <button type="submit" class="btn btn-success w-100">
                            <i class="fas fa-check"></i> Mark as Paid
                        </button>
                    </form>
                    @endif

                    <form action="{{ route('finance.settlements.invoices.destroy', $invoice) }}" method="POST" onsubmit="return confirm('Are you sure?')">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger w-100">
                            <i class="fas fa-trash"></i> Delete Invoice
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
