@extends('layouts.admin')

@section('title', 'Tax Calendar Alerts')

@section('content')
<div class="p-6 lg:p-8" x-data="{ showModal: false }" @open-modal.window="showModal = true">
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-800">Tax Calendar Alerts</h1>
            <p class="text-sm text-gray-600">Manage important tax deadlines and alerts.</p>
        </div>
        <button @click="showModal = true" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Add New Alert</button>
    </div>

    <!-- Alerts Table -->
    <div class="bg-white rounded-lg shadow-md">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Title</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Alert Date</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Frequency</th>
                        <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase">Status</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($alerts as $alert)
                        <tr>
                            <td class="px-6 py-4">{{ $alert->title }}</td>
                            <td class="px-6 py-4">{{ $alert->alert_date->format('M d, Y') }}</td>
                            <td class="px-6 py-4">{{ ucfirst($alert->frequency) }}</td>
                            <td class="px-6 py-4 text-center"><span class="px-2 py-1 text-xs rounded-full {{ $alert->is_active ? 'bg-green-100 text-green-800' : 'bg-gray-200' }}">{{ $alert->is_active ? 'Active' : 'Inactive' }}</span></td>
                        </tr>
                    @empty
                        <tr><td colspan="4" class="text-center py-10">No tax alerts found.</td></tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <!-- Add Alert Modal -->
    <div x-show="showModal" @click.away="showModal = false" class="fixed inset-0 bg-gray-600 bg-opacity-50 h-full w-full z-50" x-cloak>
        <div class="relative top-10 mx-auto p-5 border w-full max-w-lg shadow-lg rounded-md bg-white">
            <form action="{{ route('finance.taxation.calendar-alerts.store') }}" method="POST">
                @csrf
                <h3 class="text-lg font-semibold mb-4">Add New Tax Alert</h3>
                <div class="space-y-4">
                                        <div>
                        <label class="block text-sm">Title</label>
                        <input type="text" name="title" class="form-input" required>
                    </div>
                    <div>
                        <label class="block text-sm">Alert Date</label>
                        <input type="date" name="alert_date" class="form-input" required>
                    </div>
                    <div>
                        <label class="block text-sm">Frequency</label>
                        <select name="frequency" class="form-select">
                            <option value="">One-time</option>
                            <option value="monthly">Monthly</option>
                            <option value="quarterly">Quarterly</option>
                            <option value="annually">Annually</option>
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm">Description</label>
                        <textarea name="description" rows="3" class="form-input"></textarea>
                    </div>
                </div>
                <div class="flex justify-end space-x-2 mt-6">
                    <button type="button" @click="showModal = false" class="bg-gray-300 text-gray-700 px-4 py-2 rounded-lg">Close</button>
                    <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Save Alert</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function () {
        @if($errors->any())
            window.dispatchEvent(new CustomEvent('open-modal'));
        @endif
    });
</script>
@endpush



