@extends('layouts.admin')

@section('title', 'Tax Deduction Reports')

@section('content')
<div class="p-6 lg:p-8">
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-800">Tax Deduction Reports</h1>
            <p class="text-sm text-gray-600">Generate reports on all tax deductions.</p>
        </div>
    </div>

    <!-- Filters -->
    <form method="GET" action="{{ url('finance/taxation.deduction-reports') }}" class="bg-white rounded-lg shadow-md p-4 mb-6 grid grid-cols-1 md:grid-cols-3 gap-4">
        <input type="month" name="month" value="{{ request('month', date('Y-m')) }}" class="form-input">
        <select name="employee_id" class="form-select">
            <option value="">All Employees</option>
            @foreach($employees as $employee)
                <option value="{{ $employee->id }}" {{ request('employee_id') == $employee->id ? 'selected' : '' }}>{{ $employee->name }}</option>
            @endforeach
        </select>
        <button type="submit" class="bg-gray-800 text-white px-4 py-2 rounded-md">Filter</button>
    </form>

    <!-- Report Table -->
    <div class="bg-white rounded-lg shadow-md">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Employee</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Month</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Type</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Amount</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($deductions as $deduction)
                        <tr>
                            <td class="px-6 py-4">{{ $deduction->employee->name ?? 'N/A' }}</td>
                            <td class="px-6 py-4">{{ \Carbon\Carbon::parse($deduction->month)->format('F Y') }}</td>
                            <td class="px-6 py-4">{{ ucwords(str_replace('_', ' ', $deduction->type)) }}</td>
                            <td class="px-6 py-4 text-right">{{ number_format($deduction->amount, 2) }}</td>
                        </tr>
                    @empty
                        <tr><td colspan="4" class="text-center py-10">No deductions found for the selected criteria.</td></tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection



