@extends('layouts.admin')

@section('title', 'Edit Tax Rate')

@section('content')
<div class="p-6 lg:p-8">
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-800">Edit Tax Rate</h1>
            <p class="text-sm text-gray-600">Update tax rate details.</p>
        </div>
        <a href="{{ url()->previous() }}" class="bg-white text-gray-700 px-4 py-2 rounded-lg border shadow-sm hover:bg-gray-50">Back</a>
    </div>

    <div class="bg-white rounded-lg shadow-md p-6">
        <form action="{{ url('finance/taxation.tax-rates.update', $taxRate) }}" method="POST">
            @csrf
            @method('PUT')
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Rate Name</label>
                    <input type="text" name="name" value="{{ $taxRate->name }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                </div>
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Rate (%)</label>
                    <input type="number" name="rate" value="{{ $taxRate->rate }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" step="0.01" required>
                </div>
                <input type="hidden" name="type" value="{{ $taxRate->type }}">
            </div>
            <div class="flex justify-end mt-6">
                <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Update Rate</button>
            </div>
        </form>
    </div>
</div>
@endsection


