@extends('layouts.admin')

@section('title', 'Tax Filings')

@section('content')
<div class="p-6 lg:p-8" x-data="{ showModal: false }" @open-modal.window="showModal = true">
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-800">Tax Filings</h1>
            <p class="text-sm text-gray-600">Track and manage all tax filings.</p>
        </div>
        <button @click="showModal = true" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Add New Filing</button>
    </div>

    <!-- Filters -->
    <form method="GET" action="{{ url('finance/taxation.filings') }}" class="bg-white rounded-lg shadow-md p-4 mb-6 grid grid-cols-1 md:grid-cols-3 gap-4">
        <input type="month" name="period" value="{{ request('period') }}" class="form-input">
        <select name="status" class="form-select">
            <option value="">All Statuses</option>
            @foreach(['pending', 'filed', 'overdue'] as $status)
                <option value="{{ $status }}" {{ request('status') == $status ? 'selected' : '' }}>{{ ucfirst($status) }}</option>
            @endforeach
        </select>
        <button type="submit" class="bg-gray-800 text-white px-4 py-2 rounded-md">Filter</button>
    </form>

    <!-- Filings Table -->
    <div class="bg-white rounded-lg shadow-md">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Type</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Period</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Due Date</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Filed On</th>
                        <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase">Status</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($filings as $filing)
                        <tr>
                            <td class="px-6 py-4">{{ $filing->filing_type }}</td>
                            <td class="px-6 py-4">{{ $filing->period }}</td>
                            <td class="px-6 py-4">{{ $filing->due_date->format('M d, Y') }}</td>
                            <td class="px-6 py-4">{{ $filing->filed_on ? $filing->filed_on->format('M d, Y') : '-' }}</td>
                            <td class="px-6 py-4 text-center"><span class="px-2 py-1 text-xs rounded-full bg-gray-200">{{ ucfirst($filing->status) }}</span></td>
                            <td class="px-6 py-4 text-right"><a href="#" class="text-indigo-600">Edit</a></td>
                        </tr>
                    @empty
                        <tr><td colspan="6" class="text-center py-10">No tax filings found.</td></tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <!-- Add Filing Modal -->
    <div x-show="showModal" @click.away="showModal = false" class="fixed inset-0 bg-gray-600 bg-opacity-50 h-full w-full z-50" x-cloak>
        <div class="relative top-10 mx-auto p-5 border w-full max-w-lg shadow-lg rounded-md bg-white">
            <form action="{{ url('finance/taxation.filings.submit') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <h3 class="text-lg font-semibold mb-4">Add New Tax Filing</h3>
                <div class="space-y-4">
                                        <div>
                        <label class="block text-sm">Filing Type</label>
                        <input type="text" name="filing_type" class="form-input" placeholder="e.g., GSTR-1" required>
                    </div>
                    <div>
                        <label class="block text-sm">Period</label>
                        <input type="month" name="period" class="form-input" value="{{ date('Y-m') }}" required>
                    </div>
                    <div>
                        <label class="block text-sm">Due Date</label>
                        <input type="date" name="due_date" class="form-input" required>
                    </div>
                    <div>
                        <label class="block text-sm">Tax Amount (Optional)</label>
                        <input type="number" name="tax_amount" step="0.01" class="form-input">
                    </div>
                    <div>
                        <label class="block text-sm">Document (Optional)</label>
                        <input type="file" name="document_path" class="form-input">
                    </div>
                </div>
                <div class="flex justify-end space-x-2 mt-6">
                    <button type="button" @click="showModal = false" class="bg-gray-300 text-gray-700 px-4 py-2 rounded-lg">Close</button>
                    <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Save Filing</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function () {
        @if($errors->any())
            window.dispatchEvent(new CustomEvent('open-modal'));
        @endif
    });
</script>
@endpush



