@extends('layouts.admin')

@section('title', 'GST Calculation & Rates')

@section('content')
<div class="p-6 lg:p-8" x-data="{ showModal: false }" @open-modal.window="showModal = true">
    <!-- Page Header -->
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-800">GST Calculation & Rates</h1>
            <p class="text-sm text-gray-600">Manage GST rates and view calculations.</p>
        </div>
        <button @click="showModal = true" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Add New Rate</button>
    </div>

    <!-- Tax Rates Table -->
    <div class="bg-white rounded-lg shadow-md">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Name</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Type</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Rate (%)</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($taxRates as $rate)
                        <tr>
                            <td class="px-6 py-4">{{ $rate->name }}</td>
                            <td class="px-6 py-4">{{ $rate->type }}</td>
                            <td class="px-6 py-4 text-right">{{ number_format($rate->rate, 2) }}%</td>
                            <td class="px-6 py-4 text-right">
                                <a href="{{ url('finance/taxation.tax-rates.edit', $rate) }}" class="text-indigo-600 hover:text-indigo-900">Edit</a>
                                <form action="{{ url('finance/taxation.tax-rates.destroy', $rate) }}" method="POST" class="inline" onsubmit="return confirm('Are you sure?')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="text-red-600 hover:text-red-900 ml-2">Delete</button>
                                </form>
                            </td>
                        </tr>
                    @empty
                        <tr><td colspan="4" class="text-center py-10">No GST rates found.</td></tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <!-- Add Rate Modal -->
    <div x-show="showModal" @click.away="showModal = false" class="fixed inset-0 bg-gray-600 bg-opacity-50 h-full w-full z-50" x-cloak>
        <div class="relative top-10 mx-auto p-5 border w-full max-w-lg shadow-lg rounded-md bg-white">
            <form action="{{ url('finance/taxation.tax-rates.store') }}" method="POST">
                @csrf
                <h3 class="text-lg font-semibold mb-4">Add New Tax Rate</h3>
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm">Name</label>
                        <input type="text" name="name" class="form-input" required>
                    </div>
                    <div>
                        <label class="block text-sm">Rate (%)</label>
                        <input type="number" name="rate" step="0.01" class="form-input" required>
                    </div>
                    <div>
                        <label class="block text-sm">Type</label>
                        <input type="text" name="type" value="GST" class="form-input" required>
                    </div>
                </div>
                <div class="flex justify-end space-x-2 mt-6">
                    <button type="button" @click="showModal = false" class="bg-gray-300 text-gray-700 px-4 py-2 rounded-lg">Close</button>
                    <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Save Rate</button>
                </div>
            </form>
        </div>
    </div>
</div>



