@extends('layouts.admin')

@section('title', 'Edit Voucher')

@section('content')
<div class="p-6 lg:p-8">
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-800">Edit Voucher</h1>
            <p class="text-sm text-gray-600">Update voucher details.</p>
        </div>
        <a href="{{ url('finance/vouchers.index', $voucher->type) }}" class="bg-white text-gray-700 px-4 py-2 rounded-lg border shadow-sm hover:bg-gray-50">Back</a>
    </div>

    <div class="bg-white rounded-lg shadow-md p-6">
        <form action="{{ url('finance/vouchers.update', $voucher) }}" method="POST">
            @csrf
            @method('PUT')
            <div class="space-y-4">
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Voucher Date</label>
                    <input type="date" name="voucher_date" value="{{ $voucher->voucher_date->format('Y-m-d') }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                </div>
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Description</label>
                    <textarea name="description" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>{{ $voucher->description }}</textarea>
                </div>
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Amount</label>
                    <input type="number" name="amount" value="{{ $voucher->amount }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" step="0.01" required>
                </div>
            </div>
            <div class="flex justify-end mt-6">
                <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Update Voucher</button>
            </div>
        </form>
    </div>
</div>
@endsection


