@extends('layouts.admin')

@section('title', 'Attendance Management')

@section('content')
<div class="container-fluid py-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h1 class="h3">Attendance Management</h1>
        <a href="{{ route('admin.dashboard') }}" class="btn btn-outline-secondary">Back to Dashboard</a>
    </div>

    @if(session('status'))
        <div class="alert alert-success">{{ session('status') }}</div>
    @endif

    <div class="row g-3 mb-4">
        <div class="col-md-3">
            <div class="card h-100">
                <div class="card-body">
                    <div class="text-muted">Employees</div>
                    <div class="fs-4 fw-semibold">{{ $employeeCount ?? 0 }}</div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card h-100">
                <div class="card-body">
                    <div class="text-muted">Branches</div>
                    <div class="fs-4 fw-semibold">{{ $branchCount ?? 0 }}</div>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card h-100">
                <div class="card-body">
                    <div class="fw-semibold mb-2">Mark Attendance</div>
                    <form method="POST" action="{{ route('admin.hr.attendance.mark') }}" class="row g-3">
                        @csrf
                        <div class="col-md-4">
                            <label class="form-label">Employee ID</label>
                            <input type="number" class="form-control" name="employee_id" required />
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Status</label>
                            <select class="form-select" name="status" required>
                                <option value="present">Present</option>
                                <option value="absent">Absent</option>
                                <option value="late">Late</option>
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Date</label>
                            <input type="date" class="form-control" name="date" />
                        </div>
                        <div class="col-12 text-end">
                            <button type="submit" class="btn btn-primary">Save</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-header fw-semibold">Recent Employees</div>
        <div class="table-responsive">
            <table class="table table-striped mb-0">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Branch</th>
                        <th>Joined</th>
                    </tr>
                </thead>
                <tbody>
                @forelse(($recentEmployees ?? []) as $emp)
                    <tr>
                        <td>{{ $emp->name ?? '-' }}</td>
                        <td>{{ $emp->email ?? '-' }}</td>
                        <td>{{ $emp->branch->name ?? '-' }}</td>
                        <td>{{ optional($emp->created_at)->format('Y-m-d') }}</td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="4" class="text-center text-muted">No recent employees found.</td>
                    </tr>
                @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
